/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ConditionExecution;
import software.amazon.awssdk.services.codepipeline.model.RuleState;
import software.amazon.awssdk.services.codepipeline.model.RuleStateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConditionState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConditionState> {
    private static final SdkField<ConditionExecution> LATEST_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestExecution").getter(ConditionState.getter(ConditionState::latestExecution)).setter(ConditionState.setter(Builder::latestExecution)).constructor(ConditionExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()}).build();
    private static final SdkField<List<RuleState>> RULE_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleStates").getter(ConditionState.getter(ConditionState::ruleStates)).setter(ConditionState.setter(Builder::ruleStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_EXECUTION_FIELD, RULE_STATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConditionState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ConditionExecution latestExecution;
    private final List<RuleState> ruleStates;

    private ConditionState(BuilderImpl builder) {
        this.latestExecution = builder.latestExecution;
        this.ruleStates = builder.ruleStates;
    }

    public final ConditionExecution latestExecution() {
        return this.latestExecution;
    }

    public final boolean hasRuleStates() {
        return this.ruleStates != null && !(this.ruleStates instanceof SdkAutoConstructList);
    }

    public final List<RuleState> ruleStates() {
        return this.ruleStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleStates() ? this.ruleStates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionState)) {
            return false;
        }
        ConditionState other = (ConditionState)obj;
        return Objects.equals(this.latestExecution(), other.latestExecution()) && this.hasRuleStates() == other.hasRuleStates() && Objects.equals(this.ruleStates(), other.ruleStates());
    }

    public final String toString() {
        return ToString.builder((String)"ConditionState").add("LatestExecution", (Object)this.latestExecution()).add("RuleStates", this.hasRuleStates() ? this.ruleStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "latestExecution": {
                return Optional.ofNullable(clazz.cast(this.latestExecution()));
            }
            case "ruleStates": {
                return Optional.ofNullable(clazz.cast(this.ruleStates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("latestExecution", LATEST_EXECUTION_FIELD);
        map.put("ruleStates", RULE_STATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionState, T> g) {
        return obj -> g.apply((ConditionState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConditionExecution latestExecution;
        private List<RuleState> ruleStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionState model) {
            this.latestExecution(model.latestExecution);
            this.ruleStates(model.ruleStates);
        }

        public final ConditionExecution.Builder getLatestExecution() {
            return this.latestExecution != null ? this.latestExecution.toBuilder() : null;
        }

        public final void setLatestExecution(ConditionExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        @Override
        public final Builder latestExecution(ConditionExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final List<RuleState.Builder> getRuleStates() {
            List<RuleState.Builder> result = RuleStateListCopier.copyToBuilder(this.ruleStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleStates(Collection<RuleState.BuilderImpl> ruleStates) {
            this.ruleStates = RuleStateListCopier.copyFromBuilder(ruleStates);
        }

        @Override
        public final Builder ruleStates(Collection<RuleState> ruleStates) {
            this.ruleStates = RuleStateListCopier.copy(ruleStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleStates(RuleState ... ruleStates) {
            this.ruleStates(Arrays.asList(ruleStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleStates(Consumer<RuleState.Builder> ... ruleStates) {
            this.ruleStates(Stream.of(ruleStates).map(c -> (RuleState)((RuleState.Builder)RuleState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConditionState build() {
            return new ConditionState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConditionState> {
        public Builder latestExecution(ConditionExecution var1);

        default public Builder latestExecution(Consumer<ConditionExecution.Builder> latestExecution) {
            return this.latestExecution((ConditionExecution)((ConditionExecution.Builder)ConditionExecution.builder().applyMutation(latestExecution)).build());
        }

        public Builder ruleStates(Collection<RuleState> var1);

        public Builder ruleStates(RuleState ... var1);

        public Builder ruleStates(Consumer<RuleState.Builder> ... var1);
    }
}

