/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RetryTrigger {
    AUTOMATED_STAGE_RETRY("AutomatedStageRetry"),
    MANUAL_STAGE_RETRY("ManualStageRetry"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RetryTrigger> VALUE_MAP;
    private final String value;

    private RetryTrigger(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RetryTrigger fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RetryTrigger> knownValues() {
        EnumSet<RetryTrigger> knownValues = EnumSet.allOf(RetryTrigger.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RetryTrigger.class, RetryTrigger::toString);
    }
}

