/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.QueryParamMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PollForJobsRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, PollForJobsRequest> {
    private static final SdkField<ActionTypeId> ACTION_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionTypeId").getter(PollForJobsRequest.getter(PollForJobsRequest::actionTypeId)).setter(PollForJobsRequest.setter(Builder::actionTypeId)).constructor(ActionTypeId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypeId").build()}).build();
    private static final SdkField<Integer> MAX_BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxBatchSize").getter(PollForJobsRequest.getter(PollForJobsRequest::maxBatchSize)).setter(PollForJobsRequest.setter(Builder::maxBatchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBatchSize").build()}).build();
    private static final SdkField<Map<String, String>> QUERY_PARAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("queryParam").getter(PollForJobsRequest.getter(PollForJobsRequest::queryParam)).setter(PollForJobsRequest.setter(Builder::queryParam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryParam").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_ID_FIELD, MAX_BATCH_SIZE_FIELD, QUERY_PARAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PollForJobsRequest.memberNameToFieldInitializer();
    private final ActionTypeId actionTypeId;
    private final Integer maxBatchSize;
    private final Map<String, String> queryParam;

    private PollForJobsRequest(BuilderImpl builder) {
        super(builder);
        this.actionTypeId = builder.actionTypeId;
        this.maxBatchSize = builder.maxBatchSize;
        this.queryParam = builder.queryParam;
    }

    public final ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public final Integer maxBatchSize() {
        return this.maxBatchSize;
    }

    public final boolean hasQueryParam() {
        return this.queryParam != null && !(this.queryParam instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> queryParam() {
        return this.queryParam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryParam() ? this.queryParam() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForJobsRequest)) {
            return false;
        }
        PollForJobsRequest other = (PollForJobsRequest)((Object)obj);
        return Objects.equals(this.actionTypeId(), other.actionTypeId()) && Objects.equals(this.maxBatchSize(), other.maxBatchSize()) && this.hasQueryParam() == other.hasQueryParam() && Objects.equals(this.queryParam(), other.queryParam());
    }

    public final String toString() {
        return ToString.builder((String)"PollForJobsRequest").add("ActionTypeId", (Object)this.actionTypeId()).add("MaxBatchSize", (Object)this.maxBatchSize()).add("QueryParam", this.hasQueryParam() ? this.queryParam() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionTypeId": {
                return Optional.ofNullable(clazz.cast(this.actionTypeId()));
            }
            case "maxBatchSize": {
                return Optional.ofNullable(clazz.cast(this.maxBatchSize()));
            }
            case "queryParam": {
                return Optional.ofNullable(clazz.cast(this.queryParam()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionTypeId", ACTION_TYPE_ID_FIELD);
        map.put("maxBatchSize", MAX_BATCH_SIZE_FIELD);
        map.put("queryParam", QUERY_PARAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PollForJobsRequest, T> g) {
        return obj -> g.apply((PollForJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private ActionTypeId actionTypeId;
        private Integer maxBatchSize;
        private Map<String, String> queryParam = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PollForJobsRequest model) {
            super(model);
            this.actionTypeId(model.actionTypeId);
            this.maxBatchSize(model.maxBatchSize);
            this.queryParam(model.queryParam);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return this.actionTypeId != null ? this.actionTypeId.toBuilder() : null;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final Integer getMaxBatchSize() {
            return this.maxBatchSize;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public final Map<String, String> getQueryParam() {
            if (this.queryParam instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.queryParam;
        }

        public final void setQueryParam(Map<String, String> queryParam) {
            this.queryParam = QueryParamMapCopier.copy(queryParam);
        }

        @Override
        public final Builder queryParam(Map<String, String> queryParam) {
            this.queryParam = QueryParamMapCopier.copy(queryParam);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PollForJobsRequest build() {
            return new PollForJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PollForJobsRequest> {
        public Builder actionTypeId(ActionTypeId var1);

        default public Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return this.actionTypeId((ActionTypeId)((ActionTypeId.Builder)ActionTypeId.builder().applyMutation(actionTypeId)).build());
        }

        public Builder maxBatchSize(Integer var1);

        public Builder queryParam(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

