/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.PipelineVariable;
import software.amazon.awssdk.services.codepipeline.model.PipelineVariableListCopier;
import software.amazon.awssdk.services.codepipeline.model.SourceRevisionOverride;
import software.amazon.awssdk.services.codepipeline.model.SourceRevisionOverrideListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartPipelineExecutionRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, StartPipelineExecutionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartPipelineExecutionRequest.getter(StartPipelineExecutionRequest::name)).setter(StartPipelineExecutionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<PipelineVariable>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variables").getter(StartPipelineExecutionRequest.getter(StartPipelineExecutionRequest::variables)).setter(StartPipelineExecutionRequest.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(StartPipelineExecutionRequest.getter(StartPipelineExecutionRequest::clientRequestToken)).setter(StartPipelineExecutionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<SourceRevisionOverride>> SOURCE_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceRevisions").getter(StartPipelineExecutionRequest.getter(StartPipelineExecutionRequest::sourceRevisions)).setter(StartPipelineExecutionRequest.setter(Builder::sourceRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRevisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceRevisionOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VARIABLES_FIELD, CLIENT_REQUEST_TOKEN_FIELD, SOURCE_REVISIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartPipelineExecutionRequest.memberNameToFieldInitializer();
    private final String name;
    private final List<PipelineVariable> variables;
    private final String clientRequestToken;
    private final List<SourceRevisionOverride> sourceRevisions;

    private StartPipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.variables = builder.variables;
        this.clientRequestToken = builder.clientRequestToken;
        this.sourceRevisions = builder.sourceRevisions;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public final List<PipelineVariable> variables() {
        return this.variables;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasSourceRevisions() {
        return this.sourceRevisions != null && !(this.sourceRevisions instanceof SdkAutoConstructList);
    }

    public final List<SourceRevisionOverride> sourceRevisions() {
        return this.sourceRevisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceRevisions() ? this.sourceRevisions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPipelineExecutionRequest)) {
            return false;
        }
        StartPipelineExecutionRequest other = (StartPipelineExecutionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasSourceRevisions() == other.hasSourceRevisions() && Objects.equals(this.sourceRevisions(), other.sourceRevisions());
    }

    public final String toString() {
        return ToString.builder((String)"StartPipelineExecutionRequest").add("Name", (Object)this.name()).add("Variables", this.hasVariables() ? this.variables() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).add("SourceRevisions", this.hasSourceRevisions() ? this.sourceRevisions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "sourceRevisions": {
                return Optional.ofNullable(clazz.cast(this.sourceRevisions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("variables", VARIABLES_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("sourceRevisions", SOURCE_REVISIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartPipelineExecutionRequest, T> g) {
        return obj -> g.apply((StartPipelineExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<PipelineVariable> variables = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private List<SourceRevisionOverride> sourceRevisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartPipelineExecutionRequest model) {
            super(model);
            this.name(model.name);
            this.variables(model.variables);
            this.clientRequestToken(model.clientRequestToken);
            this.sourceRevisions(model.sourceRevisions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<PipelineVariable.Builder> getVariables() {
            List<PipelineVariable.Builder> result = PipelineVariableListCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<PipelineVariable.BuilderImpl> variables) {
            this.variables = PipelineVariableListCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<PipelineVariable> variables) {
            this.variables = PipelineVariableListCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(PipelineVariable ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<PipelineVariable.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (PipelineVariable)((PipelineVariable.Builder)PipelineVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<SourceRevisionOverride.Builder> getSourceRevisions() {
            List<SourceRevisionOverride.Builder> result = SourceRevisionOverrideListCopier.copyToBuilder(this.sourceRevisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceRevisions(Collection<SourceRevisionOverride.BuilderImpl> sourceRevisions) {
            this.sourceRevisions = SourceRevisionOverrideListCopier.copyFromBuilder(sourceRevisions);
        }

        @Override
        public final Builder sourceRevisions(Collection<SourceRevisionOverride> sourceRevisions) {
            this.sourceRevisions = SourceRevisionOverrideListCopier.copy(sourceRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRevisions(SourceRevisionOverride ... sourceRevisions) {
            this.sourceRevisions(Arrays.asList(sourceRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRevisions(Consumer<SourceRevisionOverride.Builder> ... sourceRevisions) {
            this.sourceRevisions(Stream.of(sourceRevisions).map(c -> (SourceRevisionOverride)((SourceRevisionOverride.Builder)SourceRevisionOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPipelineExecutionRequest build() {
            return new StartPipelineExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartPipelineExecutionRequest> {
        public Builder name(String var1);

        public Builder variables(Collection<PipelineVariable> var1);

        public Builder variables(PipelineVariable ... var1);

        public Builder variables(Consumer<PipelineVariable.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder sourceRevisions(Collection<SourceRevisionOverride> var1);

        public Builder sourceRevisions(SourceRevisionOverride ... var1);

        public Builder sourceRevisions(Consumer<SourceRevisionOverride.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

