/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.WebhookDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWebhookItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListWebhookItem> {
    private static final SdkField<WebhookDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListWebhookItem.getter(ListWebhookItem::definition)).setter(ListWebhookItem.setter(Builder::definition)).constructor(WebhookDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListWebhookItem.getter(ListWebhookItem::url)).setter(ListWebhookItem.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListWebhookItem.getter(ListWebhookItem::errorMessage)).setter(ListWebhookItem.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListWebhookItem.getter(ListWebhookItem::errorCode)).setter(ListWebhookItem.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<Instant> LAST_TRIGGERED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListWebhookItem.getter(ListWebhookItem::lastTriggered)).setter(ListWebhookItem.setter(Builder::lastTriggered)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTriggered").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListWebhookItem.getter(ListWebhookItem::arn)).setter(ListWebhookItem.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, URL_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, LAST_TRIGGERED_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final WebhookDefinition definition;
    private final String url;
    private final String errorMessage;
    private final String errorCode;
    private final Instant lastTriggered;
    private final String arn;

    private ListWebhookItem(BuilderImpl builder) {
        this.definition = builder.definition;
        this.url = builder.url;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.lastTriggered = builder.lastTriggered;
        this.arn = builder.arn;
    }

    public WebhookDefinition definition() {
        return this.definition;
    }

    public String url() {
        return this.url;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public Instant lastTriggered() {
        return this.lastTriggered;
    }

    public String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastTriggered());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebhookItem)) {
            return false;
        }
        ListWebhookItem other = (ListWebhookItem)obj;
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.lastTriggered(), other.lastTriggered()) && Objects.equals(this.arn(), other.arn());
    }

    public String toString() {
        return ToString.builder((String)"ListWebhookItem").add("Definition", (Object)this.definition()).add("Url", (Object)this.url()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorCode", (Object)this.errorCode()).add("LastTriggered", (Object)this.lastTriggered()).add("Arn", (Object)this.arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "lastTriggered": {
                return Optional.ofNullable(clazz.cast(this.lastTriggered()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebhookItem, T> g) {
        return obj -> g.apply((ListWebhookItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WebhookDefinition definition;
        private String url;
        private String errorMessage;
        private String errorCode;
        private Instant lastTriggered;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebhookItem model) {
            this.definition(model.definition);
            this.url(model.url);
            this.errorMessage(model.errorMessage);
            this.errorCode(model.errorCode);
            this.lastTriggered(model.lastTriggered);
            this.arn(model.arn);
        }

        public final WebhookDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(WebhookDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(WebhookDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final Instant getLastTriggered() {
            return this.lastTriggered;
        }

        @Override
        public final Builder lastTriggered(Instant lastTriggered) {
            this.lastTriggered = lastTriggered;
            return this;
        }

        public final void setLastTriggered(Instant lastTriggered) {
            this.lastTriggered = lastTriggered;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public ListWebhookItem build() {
            return new ListWebhookItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListWebhookItem> {
        public Builder definition(WebhookDefinition var1);

        default public Builder definition(Consumer<WebhookDefinition.Builder> definition) {
            return this.definition((WebhookDefinition)((WebhookDefinition.Builder)WebhookDefinition.builder().applyMutation(definition)).build());
        }

        public Builder url(String var1);

        public Builder errorMessage(String var1);

        public Builder errorCode(String var1);

        public Builder lastTriggered(Instant var1);

        public Builder arn(String var1);
    }
}

