/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ConditionState;
import software.amazon.awssdk.services.codepipeline.model.ConditionStateListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageConditionsExecution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StageConditionState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StageConditionState> {
    private static final SdkField<StageConditionsExecution> LATEST_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestExecution").getter(StageConditionState.getter(StageConditionState::latestExecution)).setter(StageConditionState.setter(Builder::latestExecution)).constructor(StageConditionsExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()}).build();
    private static final SdkField<List<ConditionState>> CONDITION_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conditionStates").getter(StageConditionState.getter(StageConditionState::conditionStates)).setter(StageConditionState.setter(Builder::conditionStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConditionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_EXECUTION_FIELD, CONDITION_STATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("latestExecution", LATEST_EXECUTION_FIELD);
            this.put("conditionStates", CONDITION_STATES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final StageConditionsExecution latestExecution;
    private final List<ConditionState> conditionStates;

    private StageConditionState(BuilderImpl builder) {
        this.latestExecution = builder.latestExecution;
        this.conditionStates = builder.conditionStates;
    }

    public final StageConditionsExecution latestExecution() {
        return this.latestExecution;
    }

    public final boolean hasConditionStates() {
        return this.conditionStates != null && !(this.conditionStates instanceof SdkAutoConstructList);
    }

    public final List<ConditionState> conditionStates() {
        return this.conditionStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditionStates() ? this.conditionStates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageConditionState)) {
            return false;
        }
        StageConditionState other = (StageConditionState)obj;
        return Objects.equals(this.latestExecution(), other.latestExecution()) && this.hasConditionStates() == other.hasConditionStates() && Objects.equals(this.conditionStates(), other.conditionStates());
    }

    public final String toString() {
        return ToString.builder((String)"StageConditionState").add("LatestExecution", (Object)this.latestExecution()).add("ConditionStates", this.hasConditionStates() ? this.conditionStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "latestExecution": {
                return Optional.ofNullable(clazz.cast(this.latestExecution()));
            }
            case "conditionStates": {
                return Optional.ofNullable(clazz.cast(this.conditionStates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StageConditionState, T> g) {
        return obj -> g.apply((StageConditionState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StageConditionsExecution latestExecution;
        private List<ConditionState> conditionStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StageConditionState model) {
            this.latestExecution(model.latestExecution);
            this.conditionStates(model.conditionStates);
        }

        public final StageConditionsExecution.Builder getLatestExecution() {
            return this.latestExecution != null ? this.latestExecution.toBuilder() : null;
        }

        public final void setLatestExecution(StageConditionsExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        @Override
        public final Builder latestExecution(StageConditionsExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final List<ConditionState.Builder> getConditionStates() {
            List<ConditionState.Builder> result = ConditionStateListCopier.copyToBuilder(this.conditionStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditionStates(Collection<ConditionState.BuilderImpl> conditionStates) {
            this.conditionStates = ConditionStateListCopier.copyFromBuilder(conditionStates);
        }

        @Override
        public final Builder conditionStates(Collection<ConditionState> conditionStates) {
            this.conditionStates = ConditionStateListCopier.copy(conditionStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionStates(ConditionState ... conditionStates) {
            this.conditionStates(Arrays.asList(conditionStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionStates(Consumer<ConditionState.Builder> ... conditionStates) {
            this.conditionStates(Stream.of(conditionStates).map(c -> (ConditionState)((ConditionState.Builder)ConditionState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StageConditionState build() {
            return new StageConditionState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StageConditionState> {
        public Builder latestExecution(StageConditionsExecution var1);

        default public Builder latestExecution(Consumer<StageConditionsExecution.Builder> latestExecution) {
            return this.latestExecution((StageConditionsExecution)((StageConditionsExecution.Builder)StageConditionsExecution.builder().applyMutation(latestExecution)).build());
        }

        public Builder conditionStates(Collection<ConditionState> var1);

        public Builder conditionStates(ConditionState ... var1);

        public Builder conditionStates(Consumer<ConditionState.Builder> ... var1);
    }
}

