/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionCategory;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyListCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeSettings;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetails;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.Tag;
import software.amazon.awssdk.services.codepipeline.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCustomActionTypeRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, CreateCustomActionTypeRequest> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(CreateCustomActionTypeRequest.getter(CreateCustomActionTypeRequest::categoryAsString)).setter(CreateCustomActionTypeRequest.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(CreateCustomActionTypeRequest.getter(CreateCustomActionTypeRequest::provider)).setter(CreateCustomActionTypeRequest.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(CreateCustomActionTypeRequest.getter(CreateCustomActionTypeRequest::version)).setter(CreateCustomActionTypeRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<ActionTypeSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("settings").getter(CreateCustomActionTypeRequest.getter(CreateCustomActionTypeRequest::settings)).setter(CreateCustomActionTypeRequest.setter(Builder::settings)).constructor(ActionTypeSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final SdkField<List<ActionConfigurationProperty>> CONFIGURATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configurationProperties").getter(CreateCustomActionTypeRequest.getter(CreateCustomActionTypeRequest::configurationProperties)).setter(CreateCustomActionTypeRequest.setter(Builder::configurationProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionConfigurationProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ArtifactDetails> INPUT_ARTIFACT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputArtifactDetails").getter(CreateCustomActionTypeRequest.getter(CreateCustomActionTypeRequest::inputArtifactDetails)).setter(CreateCustomActionTypeRequest.setter(Builder::inputArtifactDetails)).constructor(ArtifactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifactDetails").build()}).build();
    private static final SdkField<ArtifactDetails> OUTPUT_ARTIFACT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputArtifactDetails").getter(CreateCustomActionTypeRequest.getter(CreateCustomActionTypeRequest::outputArtifactDetails)).setter(CreateCustomActionTypeRequest.setter(Builder::outputArtifactDetails)).constructor(ArtifactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifactDetails").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateCustomActionTypeRequest.getter(CreateCustomActionTypeRequest::tags)).setter(CreateCustomActionTypeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, PROVIDER_FIELD, VERSION_FIELD, SETTINGS_FIELD, CONFIGURATION_PROPERTIES_FIELD, INPUT_ARTIFACT_DETAILS_FIELD, OUTPUT_ARTIFACT_DETAILS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("category", CATEGORY_FIELD);
            this.put("provider", PROVIDER_FIELD);
            this.put("version", VERSION_FIELD);
            this.put("settings", SETTINGS_FIELD);
            this.put("configurationProperties", CONFIGURATION_PROPERTIES_FIELD);
            this.put("inputArtifactDetails", INPUT_ARTIFACT_DETAILS_FIELD);
            this.put("outputArtifactDetails", OUTPUT_ARTIFACT_DETAILS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String category;
    private final String provider;
    private final String version;
    private final ActionTypeSettings settings;
    private final List<ActionConfigurationProperty> configurationProperties;
    private final ArtifactDetails inputArtifactDetails;
    private final ArtifactDetails outputArtifactDetails;
    private final List<Tag> tags;

    private CreateCustomActionTypeRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.provider = builder.provider;
        this.version = builder.version;
        this.settings = builder.settings;
        this.configurationProperties = builder.configurationProperties;
        this.inputArtifactDetails = builder.inputArtifactDetails;
        this.outputArtifactDetails = builder.outputArtifactDetails;
        this.tags = builder.tags;
    }

    public final ActionCategory category() {
        return ActionCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final String provider() {
        return this.provider;
    }

    public final String version() {
        return this.version;
    }

    public final ActionTypeSettings settings() {
        return this.settings;
    }

    public final boolean hasConfigurationProperties() {
        return this.configurationProperties != null && !(this.configurationProperties instanceof SdkAutoConstructList);
    }

    public final List<ActionConfigurationProperty> configurationProperties() {
        return this.configurationProperties;
    }

    public final ArtifactDetails inputArtifactDetails() {
        return this.inputArtifactDetails;
    }

    public final ArtifactDetails outputArtifactDetails() {
        return this.outputArtifactDetails;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationProperties() ? this.configurationProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomActionTypeRequest)) {
            return false;
        }
        CreateCustomActionTypeRequest other = (CreateCustomActionTypeRequest)((Object)obj);
        return Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.settings(), other.settings()) && this.hasConfigurationProperties() == other.hasConfigurationProperties() && Objects.equals(this.configurationProperties(), other.configurationProperties()) && Objects.equals(this.inputArtifactDetails(), other.inputArtifactDetails()) && Objects.equals(this.outputArtifactDetails(), other.outputArtifactDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCustomActionTypeRequest").add("Category", (Object)this.categoryAsString()).add("Provider", (Object)this.provider()).add("Version", (Object)this.version()).add("Settings", (Object)this.settings()).add("ConfigurationProperties", this.hasConfigurationProperties() ? this.configurationProperties() : null).add("InputArtifactDetails", (Object)this.inputArtifactDetails()).add("OutputArtifactDetails", (Object)this.outputArtifactDetails()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "configurationProperties": {
                return Optional.ofNullable(clazz.cast(this.configurationProperties()));
            }
            case "inputArtifactDetails": {
                return Optional.ofNullable(clazz.cast(this.inputArtifactDetails()));
            }
            case "outputArtifactDetails": {
                return Optional.ofNullable(clazz.cast(this.outputArtifactDetails()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomActionTypeRequest, T> g) {
        return obj -> g.apply((CreateCustomActionTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String category;
        private String provider;
        private String version;
        private ActionTypeSettings settings;
        private List<ActionConfigurationProperty> configurationProperties = DefaultSdkAutoConstructList.getInstance();
        private ArtifactDetails inputArtifactDetails;
        private ArtifactDetails outputArtifactDetails;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomActionTypeRequest model) {
            super(model);
            this.category(model.category);
            this.provider(model.provider);
            this.version(model.version);
            this.settings(model.settings);
            this.configurationProperties(model.configurationProperties);
            this.inputArtifactDetails(model.inputArtifactDetails);
            this.outputArtifactDetails(model.outputArtifactDetails);
            this.tags(model.tags);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final ActionTypeSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(ActionTypeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(ActionTypeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<ActionConfigurationProperty.Builder> getConfigurationProperties() {
            List<ActionConfigurationProperty.Builder> result = ActionConfigurationPropertyListCopier.copyToBuilder(this.configurationProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationProperties(Collection<ActionConfigurationProperty.BuilderImpl> configurationProperties) {
            this.configurationProperties = ActionConfigurationPropertyListCopier.copyFromBuilder(configurationProperties);
        }

        @Override
        public final Builder configurationProperties(Collection<ActionConfigurationProperty> configurationProperties) {
            this.configurationProperties = ActionConfigurationPropertyListCopier.copy(configurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(ActionConfigurationProperty ... configurationProperties) {
            this.configurationProperties(Arrays.asList(configurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(Consumer<ActionConfigurationProperty.Builder> ... configurationProperties) {
            this.configurationProperties(Stream.of(configurationProperties).map(c -> (ActionConfigurationProperty)((ActionConfigurationProperty.Builder)ActionConfigurationProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ArtifactDetails.Builder getInputArtifactDetails() {
            return this.inputArtifactDetails != null ? this.inputArtifactDetails.toBuilder() : null;
        }

        public final void setInputArtifactDetails(ArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        public final ArtifactDetails.Builder getOutputArtifactDetails() {
            return this.outputArtifactDetails != null ? this.outputArtifactDetails.toBuilder() : null;
        }

        public final void setOutputArtifactDetails(ArtifactDetails.BuilderImpl outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails != null ? outputArtifactDetails.build() : null;
        }

        @Override
        public final Builder outputArtifactDetails(ArtifactDetails outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomActionTypeRequest build() {
            return new CreateCustomActionTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCustomActionTypeRequest> {
        public Builder category(String var1);

        public Builder category(ActionCategory var1);

        public Builder provider(String var1);

        public Builder version(String var1);

        public Builder settings(ActionTypeSettings var1);

        default public Builder settings(Consumer<ActionTypeSettings.Builder> settings) {
            return this.settings((ActionTypeSettings)((ActionTypeSettings.Builder)ActionTypeSettings.builder().applyMutation(settings)).build());
        }

        public Builder configurationProperties(Collection<ActionConfigurationProperty> var1);

        public Builder configurationProperties(ActionConfigurationProperty ... var1);

        public Builder configurationProperties(Consumer<ActionConfigurationProperty.Builder> ... var1);

        public Builder inputArtifactDetails(ArtifactDetails var1);

        default public Builder inputArtifactDetails(Consumer<ArtifactDetails.Builder> inputArtifactDetails) {
            return this.inputArtifactDetails((ArtifactDetails)((ArtifactDetails.Builder)ArtifactDetails.builder().applyMutation(inputArtifactDetails)).build());
        }

        public Builder outputArtifactDetails(ArtifactDetails var1);

        default public Builder outputArtifactDetails(Consumer<ArtifactDetails.Builder> outputArtifactDetails) {
            return this.outputArtifactDetails((ArtifactDetails)((ArtifactDetails.Builder)ArtifactDetails.builder().applyMutation(outputArtifactDetails)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

