/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ActionCategory;
import software.amazon.awssdk.services.codepipeline.model.ActionOwner;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionTypeId
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionTypeId> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(ActionTypeId.getter(ActionTypeId::categoryAsString)).setter(ActionTypeId.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(ActionTypeId.getter(ActionTypeId::ownerAsString)).setter(ActionTypeId.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(ActionTypeId.getter(ActionTypeId::provider)).setter(ActionTypeId.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ActionTypeId.getter(ActionTypeId::version)).setter(ActionTypeId.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, OWNER_FIELD, PROVIDER_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("category", CATEGORY_FIELD);
            this.put("owner", OWNER_FIELD);
            this.put("provider", PROVIDER_FIELD);
            this.put("version", VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String category;
    private final String owner;
    private final String provider;
    private final String version;

    private ActionTypeId(BuilderImpl builder) {
        this.category = builder.category;
        this.owner = builder.owner;
        this.provider = builder.provider;
        this.version = builder.version;
    }

    public final ActionCategory category() {
        return ActionCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final ActionOwner owner() {
        return ActionOwner.fromValue(this.owner);
    }

    public final String ownerAsString() {
        return this.owner;
    }

    public final String provider() {
        return this.provider;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeId)) {
            return false;
        }
        ActionTypeId other = (ActionTypeId)obj;
        return Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.ownerAsString(), other.ownerAsString()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"ActionTypeId").add("Category", (Object)this.categoryAsString()).add("Owner", (Object)this.ownerAsString()).add("Provider", (Object)this.provider()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.ownerAsString()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ActionTypeId, T> g) {
        return obj -> g.apply((ActionTypeId)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private String owner;
        private String provider;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeId model) {
            this.category(model.category);
            this.owner(model.owner);
            this.provider(model.provider);
            this.version(model.version);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(ActionOwner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public ActionTypeId build() {
            return new ActionTypeId(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionTypeId> {
        public Builder category(String var1);

        public Builder category(ActionCategory var1);

        public Builder owner(String var1);

        public Builder owner(ActionOwner var1);

        public Builder provider(String var1);

        public Builder version(String var1);
    }
}

