/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.RuleExecutionDetail;
import software.amazon.awssdk.services.codepipeline.model.RuleExecutionDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRuleExecutionsResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, ListRuleExecutionsResponse> {
    private static final SdkField<List<RuleExecutionDetail>> RULE_EXECUTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleExecutionDetails").getter(ListRuleExecutionsResponse.getter(ListRuleExecutionsResponse::ruleExecutionDetails)).setter(ListRuleExecutionsResponse.setter(Builder::ruleExecutionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleExecutionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRuleExecutionsResponse.getter(ListRuleExecutionsResponse::nextToken)).setter(ListRuleExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_EXECUTION_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ruleExecutionDetails", RULE_EXECUTION_DETAILS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<RuleExecutionDetail> ruleExecutionDetails;
    private final String nextToken;

    private ListRuleExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.ruleExecutionDetails = builder.ruleExecutionDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRuleExecutionDetails() {
        return this.ruleExecutionDetails != null && !(this.ruleExecutionDetails instanceof SdkAutoConstructList);
    }

    public final List<RuleExecutionDetail> ruleExecutionDetails() {
        return this.ruleExecutionDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleExecutionDetails() ? this.ruleExecutionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleExecutionsResponse)) {
            return false;
        }
        ListRuleExecutionsResponse other = (ListRuleExecutionsResponse)((Object)obj);
        return this.hasRuleExecutionDetails() == other.hasRuleExecutionDetails() && Objects.equals(this.ruleExecutionDetails(), other.ruleExecutionDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRuleExecutionsResponse").add("RuleExecutionDetails", this.hasRuleExecutionDetails() ? this.ruleExecutionDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleExecutionDetails": {
                return Optional.ofNullable(clazz.cast(this.ruleExecutionDetails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRuleExecutionsResponse, T> g) {
        return obj -> g.apply((ListRuleExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private List<RuleExecutionDetail> ruleExecutionDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleExecutionsResponse model) {
            super(model);
            this.ruleExecutionDetails(model.ruleExecutionDetails);
            this.nextToken(model.nextToken);
        }

        public final List<RuleExecutionDetail.Builder> getRuleExecutionDetails() {
            List<RuleExecutionDetail.Builder> result = RuleExecutionDetailListCopier.copyToBuilder(this.ruleExecutionDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleExecutionDetails(Collection<RuleExecutionDetail.BuilderImpl> ruleExecutionDetails) {
            this.ruleExecutionDetails = RuleExecutionDetailListCopier.copyFromBuilder(ruleExecutionDetails);
        }

        @Override
        public final Builder ruleExecutionDetails(Collection<RuleExecutionDetail> ruleExecutionDetails) {
            this.ruleExecutionDetails = RuleExecutionDetailListCopier.copy(ruleExecutionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleExecutionDetails(RuleExecutionDetail ... ruleExecutionDetails) {
            this.ruleExecutionDetails(Arrays.asList(ruleExecutionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleExecutionDetails(Consumer<RuleExecutionDetail.Builder> ... ruleExecutionDetails) {
            this.ruleExecutionDetails(Stream.of(ruleExecutionDetails).map(c -> (RuleExecutionDetail)((RuleExecutionDetail.Builder)RuleExecutionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRuleExecutionsResponse build() {
            return new ListRuleExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRuleExecutionsResponse> {
        public Builder ruleExecutionDetails(Collection<RuleExecutionDetail> var1);

        public Builder ruleExecutionDetails(RuleExecutionDetail ... var1);

        public Builder ruleExecutionDetails(Consumer<RuleExecutionDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

