/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetails;
import software.amazon.awssdk.services.codepipeline.model.RuleConfigurationProperty;
import software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyListCopier;
import software.amazon.awssdk.services.codepipeline.model.RuleTypeId;
import software.amazon.awssdk.services.codepipeline.model.RuleTypeSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleType> {
    private static final SdkField<RuleTypeId> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("id").getter(RuleType.getter(RuleType::id)).setter(RuleType.setter(Builder::id)).constructor(RuleTypeId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<RuleTypeSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("settings").getter(RuleType.getter(RuleType::settings)).setter(RuleType.setter(Builder::settings)).constructor(RuleTypeSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final SdkField<List<RuleConfigurationProperty>> RULE_CONFIGURATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleConfigurationProperties").getter(RuleType.getter(RuleType::ruleConfigurationProperties)).setter(RuleType.setter(Builder::ruleConfigurationProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleConfigurationProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleConfigurationProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ArtifactDetails> INPUT_ARTIFACT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputArtifactDetails").getter(RuleType.getter(RuleType::inputArtifactDetails)).setter(RuleType.setter(Builder::inputArtifactDetails)).constructor(ArtifactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifactDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SETTINGS_FIELD, RULE_CONFIGURATION_PROPERTIES_FIELD, INPUT_ARTIFACT_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final RuleTypeId id;
    private final RuleTypeSettings settings;
    private final List<RuleConfigurationProperty> ruleConfigurationProperties;
    private final ArtifactDetails inputArtifactDetails;

    private RuleType(BuilderImpl builder) {
        this.id = builder.id;
        this.settings = builder.settings;
        this.ruleConfigurationProperties = builder.ruleConfigurationProperties;
        this.inputArtifactDetails = builder.inputArtifactDetails;
    }

    public final RuleTypeId id() {
        return this.id;
    }

    public final RuleTypeSettings settings() {
        return this.settings;
    }

    public final boolean hasRuleConfigurationProperties() {
        return this.ruleConfigurationProperties != null && !(this.ruleConfigurationProperties instanceof SdkAutoConstructList);
    }

    public final List<RuleConfigurationProperty> ruleConfigurationProperties() {
        return this.ruleConfigurationProperties;
    }

    public final ArtifactDetails inputArtifactDetails() {
        return this.inputArtifactDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleConfigurationProperties() ? this.ruleConfigurationProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputArtifactDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleType)) {
            return false;
        }
        RuleType other = (RuleType)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.settings(), other.settings()) && this.hasRuleConfigurationProperties() == other.hasRuleConfigurationProperties() && Objects.equals(this.ruleConfigurationProperties(), other.ruleConfigurationProperties()) && Objects.equals(this.inputArtifactDetails(), other.inputArtifactDetails());
    }

    public final String toString() {
        return ToString.builder((String)"RuleType").add("Id", (Object)this.id()).add("Settings", (Object)this.settings()).add("RuleConfigurationProperties", this.hasRuleConfigurationProperties() ? this.ruleConfigurationProperties() : null).add("InputArtifactDetails", (Object)this.inputArtifactDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "ruleConfigurationProperties": {
                return Optional.ofNullable(clazz.cast(this.ruleConfigurationProperties()));
            }
            case "inputArtifactDetails": {
                return Optional.ofNullable(clazz.cast(this.inputArtifactDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleType, T> g) {
        return obj -> g.apply((RuleType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RuleTypeId id;
        private RuleTypeSettings settings;
        private List<RuleConfigurationProperty> ruleConfigurationProperties = DefaultSdkAutoConstructList.getInstance();
        private ArtifactDetails inputArtifactDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleType model) {
            this.id(model.id);
            this.settings(model.settings);
            this.ruleConfigurationProperties(model.ruleConfigurationProperties);
            this.inputArtifactDetails(model.inputArtifactDetails);
        }

        public final RuleTypeId.Builder getId() {
            return this.id != null ? this.id.toBuilder() : null;
        }

        public final void setId(RuleTypeId.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(RuleTypeId id) {
            this.id = id;
            return this;
        }

        public final RuleTypeSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(RuleTypeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(RuleTypeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final List<RuleConfigurationProperty.Builder> getRuleConfigurationProperties() {
            List<RuleConfigurationProperty.Builder> result = RuleConfigurationPropertyListCopier.copyToBuilder(this.ruleConfigurationProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleConfigurationProperties(Collection<RuleConfigurationProperty.BuilderImpl> ruleConfigurationProperties) {
            this.ruleConfigurationProperties = RuleConfigurationPropertyListCopier.copyFromBuilder(ruleConfigurationProperties);
        }

        @Override
        public final Builder ruleConfigurationProperties(Collection<RuleConfigurationProperty> ruleConfigurationProperties) {
            this.ruleConfigurationProperties = RuleConfigurationPropertyListCopier.copy(ruleConfigurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleConfigurationProperties(RuleConfigurationProperty ... ruleConfigurationProperties) {
            this.ruleConfigurationProperties(Arrays.asList(ruleConfigurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleConfigurationProperties(Consumer<RuleConfigurationProperty.Builder> ... ruleConfigurationProperties) {
            this.ruleConfigurationProperties(Stream.of(ruleConfigurationProperties).map(c -> (RuleConfigurationProperty)((RuleConfigurationProperty.Builder)RuleConfigurationProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ArtifactDetails.Builder getInputArtifactDetails() {
            return this.inputArtifactDetails != null ? this.inputArtifactDetails.toBuilder() : null;
        }

        public final void setInputArtifactDetails(ArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        public RuleType build() {
            return new RuleType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleType> {
        public Builder id(RuleTypeId var1);

        default public Builder id(Consumer<RuleTypeId.Builder> id) {
            return this.id((RuleTypeId)((RuleTypeId.Builder)RuleTypeId.builder().applyMutation(id)).build());
        }

        public Builder settings(RuleTypeSettings var1);

        default public Builder settings(Consumer<RuleTypeSettings.Builder> settings) {
            return this.settings((RuleTypeSettings)((RuleTypeSettings.Builder)RuleTypeSettings.builder().applyMutation(settings)).build());
        }

        public Builder ruleConfigurationProperties(Collection<RuleConfigurationProperty> var1);

        public Builder ruleConfigurationProperties(RuleConfigurationProperty ... var1);

        public Builder ruleConfigurationProperties(Consumer<RuleConfigurationProperty.Builder> ... var1);

        public Builder inputArtifactDetails(ArtifactDetails var1);

        default public Builder inputArtifactDetails(Consumer<ArtifactDetails.Builder> inputArtifactDetails) {
            return this.inputArtifactDetails((ArtifactDetails)((ArtifactDetails.Builder)ArtifactDetails.builder().applyMutation(inputArtifactDetails)).build());
        }
    }
}

