/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>PutActionRevision</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutActionRevisionRequest extends CodePipelineRequest implements
        ToCopyableBuilder<PutActionRevisionRequest.Builder, PutActionRevisionRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(PutActionRevisionRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(PutActionRevisionRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionName").getter(getter(PutActionRevisionRequest::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<ActionRevision> ACTION_REVISION_FIELD = SdkField
            .<ActionRevision> builder(MarshallingType.SDK_POJO).memberName("actionRevision")
            .getter(getter(PutActionRevisionRequest::actionRevision)).setter(setter(Builder::actionRevision))
            .constructor(ActionRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            STAGE_NAME_FIELD, ACTION_NAME_FIELD, ACTION_REVISION_FIELD));

    private final String pipelineName;

    private final String stageName;

    private final String actionName;

    private final ActionRevision actionRevision;

    private PutActionRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.actionName = builder.actionName;
        this.actionRevision = builder.actionRevision;
    }

    /**
     * <p>
     * The name of the pipeline that starts processing the revision to the source.
     * </p>
     * 
     * @return The name of the pipeline that starts processing the revision to the source.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The name of the stage that contains the action that acts on the revision.
     * </p>
     * 
     * @return The name of the stage that contains the action that acts on the revision.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The name of the action that processes the revision.
     * </p>
     * 
     * @return The name of the action that processes the revision.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * Represents information about the version (or revision) of an action.
     * </p>
     * 
     * @return Represents information about the version (or revision) of an action.
     */
    public final ActionRevision actionRevision() {
        return actionRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(actionRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutActionRevisionRequest)) {
            return false;
        }
        PutActionRevisionRequest other = (PutActionRevisionRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(actionName(), other.actionName()) && Objects.equals(actionRevision(), other.actionRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutActionRevisionRequest").add("PipelineName", pipelineName()).add("StageName", stageName())
                .add("ActionName", actionName()).add("ActionRevision", actionRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "actionRevision":
            return Optional.ofNullable(clazz.cast(actionRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutActionRevisionRequest, T> g) {
        return obj -> g.apply((PutActionRevisionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutActionRevisionRequest> {
        /**
         * <p>
         * The name of the pipeline that starts processing the revision to the source.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline that starts processing the revision to the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The name of the stage that contains the action that acts on the revision.
         * </p>
         * 
         * @param stageName
         *        The name of the stage that contains the action that acts on the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The name of the action that processes the revision.
         * </p>
         * 
         * @param actionName
         *        The name of the action that processes the revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * Represents information about the version (or revision) of an action.
         * </p>
         * 
         * @param actionRevision
         *        Represents information about the version (or revision) of an action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionRevision(ActionRevision actionRevision);

        /**
         * <p>
         * Represents information about the version (or revision) of an action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionRevision.Builder} avoiding the need
         * to create one manually via {@link ActionRevision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionRevision.Builder#build()} is called immediately and its
         * result is passed to {@link #actionRevision(ActionRevision)}.
         * 
         * @param actionRevision
         *        a consumer that will call methods on {@link ActionRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionRevision(ActionRevision)
         */
        default Builder actionRevision(Consumer<ActionRevision.Builder> actionRevision) {
            return actionRevision(ActionRevision.builder().applyMutation(actionRevision).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String stageName;

        private String actionName;

        private ActionRevision actionRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(PutActionRevisionRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            stageName(model.stageName);
            actionName(model.actionName);
            actionRevision(model.actionRevision);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final ActionRevision.Builder getActionRevision() {
            return actionRevision != null ? actionRevision.toBuilder() : null;
        }

        public final void setActionRevision(ActionRevision.BuilderImpl actionRevision) {
            this.actionRevision = actionRevision != null ? actionRevision.build() : null;
        }

        @Override
        public final Builder actionRevision(ActionRevision actionRevision) {
            this.actionRevision = actionRevision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutActionRevisionRequest build() {
            return new PutActionRevisionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
