/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExecutorType {
    JOB_WORKER("JobWorker"),
    LAMBDA("Lambda"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExecutorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExecutorType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutorType> knownValues() {
        return Stream.of(ExecutorType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

