/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationPropertyListCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeSettings;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionType> {
    private static final SdkField<ActionTypeId> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("id").getter(ActionType.getter(ActionType::id)).setter(ActionType.setter(Builder::id)).constructor(ActionTypeId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ActionTypeSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("settings").getter(ActionType.getter(ActionType::settings)).setter(ActionType.setter(Builder::settings)).constructor(ActionTypeSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final SdkField<List<ActionConfigurationProperty>> ACTION_CONFIGURATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionConfigurationProperties").getter(ActionType.getter(ActionType::actionConfigurationProperties)).setter(ActionType.setter(Builder::actionConfigurationProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionConfigurationProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionConfigurationProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ArtifactDetails> INPUT_ARTIFACT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputArtifactDetails").getter(ActionType.getter(ActionType::inputArtifactDetails)).setter(ActionType.setter(Builder::inputArtifactDetails)).constructor(ArtifactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifactDetails").build()}).build();
    private static final SdkField<ArtifactDetails> OUTPUT_ARTIFACT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputArtifactDetails").getter(ActionType.getter(ActionType::outputArtifactDetails)).setter(ActionType.setter(Builder::outputArtifactDetails)).constructor(ArtifactDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifactDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SETTINGS_FIELD, ACTION_CONFIGURATION_PROPERTIES_FIELD, INPUT_ARTIFACT_DETAILS_FIELD, OUTPUT_ARTIFACT_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ActionTypeId id;
    private final ActionTypeSettings settings;
    private final List<ActionConfigurationProperty> actionConfigurationProperties;
    private final ArtifactDetails inputArtifactDetails;
    private final ArtifactDetails outputArtifactDetails;

    private ActionType(BuilderImpl builder) {
        this.id = builder.id;
        this.settings = builder.settings;
        this.actionConfigurationProperties = builder.actionConfigurationProperties;
        this.inputArtifactDetails = builder.inputArtifactDetails;
        this.outputArtifactDetails = builder.outputArtifactDetails;
    }

    public ActionTypeId id() {
        return this.id;
    }

    public ActionTypeSettings settings() {
        return this.settings;
    }

    public boolean hasActionConfigurationProperties() {
        return this.actionConfigurationProperties != null && !(this.actionConfigurationProperties instanceof SdkAutoConstructList);
    }

    public List<ActionConfigurationProperty> actionConfigurationProperties() {
        return this.actionConfigurationProperties;
    }

    public ArtifactDetails inputArtifactDetails() {
        return this.inputArtifactDetails;
    }

    public ArtifactDetails outputArtifactDetails() {
        return this.outputArtifactDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionConfigurationProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputArtifactDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArtifactDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionType)) {
            return false;
        }
        ActionType other = (ActionType)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.actionConfigurationProperties(), other.actionConfigurationProperties()) && Objects.equals(this.inputArtifactDetails(), other.inputArtifactDetails()) && Objects.equals(this.outputArtifactDetails(), other.outputArtifactDetails());
    }

    public String toString() {
        return ToString.builder((String)"ActionType").add("Id", (Object)this.id()).add("Settings", (Object)this.settings()).add("ActionConfigurationProperties", this.actionConfigurationProperties()).add("InputArtifactDetails", (Object)this.inputArtifactDetails()).add("OutputArtifactDetails", (Object)this.outputArtifactDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "actionConfigurationProperties": {
                return Optional.ofNullable(clazz.cast(this.actionConfigurationProperties()));
            }
            case "inputArtifactDetails": {
                return Optional.ofNullable(clazz.cast(this.inputArtifactDetails()));
            }
            case "outputArtifactDetails": {
                return Optional.ofNullable(clazz.cast(this.outputArtifactDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionType, T> g) {
        return obj -> g.apply((ActionType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActionTypeId id;
        private ActionTypeSettings settings;
        private List<ActionConfigurationProperty> actionConfigurationProperties = DefaultSdkAutoConstructList.getInstance();
        private ArtifactDetails inputArtifactDetails;
        private ArtifactDetails outputArtifactDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionType model) {
            this.id(model.id);
            this.settings(model.settings);
            this.actionConfigurationProperties(model.actionConfigurationProperties);
            this.inputArtifactDetails(model.inputArtifactDetails);
            this.outputArtifactDetails(model.outputArtifactDetails);
        }

        public final ActionTypeId.Builder getId() {
            return this.id != null ? this.id.toBuilder() : null;
        }

        @Override
        public final Builder id(ActionTypeId id) {
            this.id = id;
            return this;
        }

        public final void setId(ActionTypeId.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        public final ActionTypeSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(ActionTypeSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(ActionTypeSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final Collection<ActionConfigurationProperty.Builder> getActionConfigurationProperties() {
            return this.actionConfigurationProperties != null ? (Collection)this.actionConfigurationProperties.stream().map(ActionConfigurationProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionConfigurationProperties(Collection<ActionConfigurationProperty> actionConfigurationProperties) {
            this.actionConfigurationProperties = ActionConfigurationPropertyListCopier.copy(actionConfigurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurationProperties(ActionConfigurationProperty ... actionConfigurationProperties) {
            this.actionConfigurationProperties(Arrays.asList(actionConfigurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurationProperties(Consumer<ActionConfigurationProperty.Builder> ... actionConfigurationProperties) {
            this.actionConfigurationProperties(Stream.of(actionConfigurationProperties).map(c -> (ActionConfigurationProperty)((ActionConfigurationProperty.Builder)ActionConfigurationProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActionConfigurationProperties(Collection<ActionConfigurationProperty.BuilderImpl> actionConfigurationProperties) {
            this.actionConfigurationProperties = ActionConfigurationPropertyListCopier.copyFromBuilder(actionConfigurationProperties);
        }

        public final ArtifactDetails.Builder getInputArtifactDetails() {
            return this.inputArtifactDetails != null ? this.inputArtifactDetails.toBuilder() : null;
        }

        @Override
        public final Builder inputArtifactDetails(ArtifactDetails inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails;
            return this;
        }

        public final void setInputArtifactDetails(ArtifactDetails.BuilderImpl inputArtifactDetails) {
            this.inputArtifactDetails = inputArtifactDetails != null ? inputArtifactDetails.build() : null;
        }

        public final ArtifactDetails.Builder getOutputArtifactDetails() {
            return this.outputArtifactDetails != null ? this.outputArtifactDetails.toBuilder() : null;
        }

        @Override
        public final Builder outputArtifactDetails(ArtifactDetails outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails;
            return this;
        }

        public final void setOutputArtifactDetails(ArtifactDetails.BuilderImpl outputArtifactDetails) {
            this.outputArtifactDetails = outputArtifactDetails != null ? outputArtifactDetails.build() : null;
        }

        public ActionType build() {
            return new ActionType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionType> {
        public Builder id(ActionTypeId var1);

        default public Builder id(Consumer<ActionTypeId.Builder> id) {
            return this.id((ActionTypeId)((ActionTypeId.Builder)ActionTypeId.builder().applyMutation(id)).build());
        }

        public Builder settings(ActionTypeSettings var1);

        default public Builder settings(Consumer<ActionTypeSettings.Builder> settings) {
            return this.settings((ActionTypeSettings)((ActionTypeSettings.Builder)ActionTypeSettings.builder().applyMutation(settings)).build());
        }

        public Builder actionConfigurationProperties(Collection<ActionConfigurationProperty> var1);

        public Builder actionConfigurationProperties(ActionConfigurationProperty ... var1);

        public Builder actionConfigurationProperties(Consumer<ActionConfigurationProperty.Builder> ... var1);

        public Builder inputArtifactDetails(ArtifactDetails var1);

        default public Builder inputArtifactDetails(Consumer<ArtifactDetails.Builder> inputArtifactDetails) {
            return this.inputArtifactDetails((ArtifactDetails)((ArtifactDetails.Builder)ArtifactDetails.builder().applyMutation(inputArtifactDetails)).build());
        }

        public Builder outputArtifactDetails(ArtifactDetails var1);

        default public Builder outputArtifactDetails(Consumer<ArtifactDetails.Builder> outputArtifactDetails) {
            return this.outputArtifactDetails((ArtifactDetails)((ArtifactDetails.Builder)ArtifactDetails.builder().applyMutation(outputArtifactDetails)).build());
        }
    }
}

