/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TriggerType {
    CREATE_PIPELINE("CreatePipeline"),
    START_PIPELINE_EXECUTION("StartPipelineExecution"),
    POLL_FOR_SOURCE_CHANGES("PollForSourceChanges"),
    WEBHOOK("Webhook"),
    CLOUD_WATCH_EVENT("CloudWatchEvent"),
    PUT_ACTION_REVISION("PutActionRevision"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TriggerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TriggerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TriggerType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TriggerType> knownValues() {
        return Stream.of(TriggerType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

