/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionDeclaration;
import software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration;
import software.amazon.awssdk.services.codepipeline.model.StageActionDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageBlockerDeclarationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StageDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StageDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StageDeclaration.getter(StageDeclaration::name)).setter(StageDeclaration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<BlockerDeclaration>> BLOCKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockers").getter(StageDeclaration.getter(StageDeclaration::blockers)).setter(StageDeclaration.setter(Builder::blockers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlockerDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ActionDeclaration>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(StageDeclaration.getter(StageDeclaration::actions)).setter(StageDeclaration.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, BLOCKERS_FIELD, ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<BlockerDeclaration> blockers;
    private final List<ActionDeclaration> actions;

    private StageDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.blockers = builder.blockers;
        this.actions = builder.actions;
    }

    public String name() {
        return this.name;
    }

    public boolean hasBlockers() {
        return this.blockers != null && !(this.blockers instanceof SdkAutoConstructList);
    }

    public List<BlockerDeclaration> blockers() {
        return this.blockers;
    }

    public boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public List<ActionDeclaration> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockers());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageDeclaration)) {
            return false;
        }
        StageDeclaration other = (StageDeclaration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.blockers(), other.blockers()) && Objects.equals(this.actions(), other.actions());
    }

    public String toString() {
        return ToString.builder((String)"StageDeclaration").add("Name", (Object)this.name()).add("Blockers", this.blockers()).add("Actions", this.actions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "blockers": {
                return Optional.ofNullable(clazz.cast(this.blockers()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StageDeclaration, T> g) {
        return obj -> g.apply((StageDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<BlockerDeclaration> blockers = DefaultSdkAutoConstructList.getInstance();
        private List<ActionDeclaration> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StageDeclaration model) {
            this.name(model.name);
            this.blockers(model.blockers);
            this.actions(model.actions);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<BlockerDeclaration.Builder> getBlockers() {
            return this.blockers != null ? (Collection)this.blockers.stream().map(BlockerDeclaration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockers(Collection<BlockerDeclaration> blockers) {
            this.blockers = StageBlockerDeclarationListCopier.copy(blockers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockers(BlockerDeclaration ... blockers) {
            this.blockers(Arrays.asList(blockers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockers(Consumer<BlockerDeclaration.Builder> ... blockers) {
            this.blockers(Stream.of(blockers).map(c -> (BlockerDeclaration)((BlockerDeclaration.Builder)BlockerDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockers(Collection<BlockerDeclaration.BuilderImpl> blockers) {
            this.blockers = StageBlockerDeclarationListCopier.copyFromBuilder(blockers);
        }

        public final Collection<ActionDeclaration.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(ActionDeclaration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<ActionDeclaration> actions) {
            this.actions = StageActionDeclarationListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ActionDeclaration ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ActionDeclaration.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (ActionDeclaration)((ActionDeclaration.Builder)ActionDeclaration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<ActionDeclaration.BuilderImpl> actions) {
            this.actions = StageActionDeclarationListCopier.copyFromBuilder(actions);
        }

        public StageDeclaration build() {
            return new StageDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StageDeclaration> {
        public Builder name(String var1);

        public Builder blockers(Collection<BlockerDeclaration> var1);

        public Builder blockers(BlockerDeclaration ... var1);

        public Builder blockers(Consumer<BlockerDeclaration.Builder> ... var1);

        public Builder actions(Collection<ActionDeclaration> var1);

        public Builder actions(ActionDeclaration ... var1);

        public Builder actions(Consumer<ActionDeclaration.Builder> ... var1);
    }
}

