/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.StageState;
import software.amazon.awssdk.services.codepipeline.model.StageStateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPipelineStateResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, GetPipelineStateResponse> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(GetPipelineStateResponse.getter(GetPipelineStateResponse::pipelineName)).setter(GetPipelineStateResponse.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()}).build();
    private static final SdkField<Integer> PIPELINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pipelineVersion").getter(GetPipelineStateResponse.getter(GetPipelineStateResponse::pipelineVersion)).setter(GetPipelineStateResponse.setter(Builder::pipelineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineVersion").build()}).build();
    private static final SdkField<List<StageState>> STAGE_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stageStates").getter(GetPipelineStateResponse.getter(GetPipelineStateResponse::stageStates)).setter(GetPipelineStateResponse.setter(Builder::stageStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StageState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(GetPipelineStateResponse.getter(GetPipelineStateResponse::created)).setter(GetPipelineStateResponse.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<Instant> UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updated").getter(GetPipelineStateResponse.getter(GetPipelineStateResponse::updated)).setter(GetPipelineStateResponse.setter(Builder::updated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_VERSION_FIELD, STAGE_STATES_FIELD, CREATED_FIELD, UPDATED_FIELD));
    private final String pipelineName;
    private final Integer pipelineVersion;
    private final List<StageState> stageStates;
    private final Instant created;
    private final Instant updated;

    private GetPipelineStateResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineVersion = builder.pipelineVersion;
        this.stageStates = builder.stageStates;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public Integer pipelineVersion() {
        return this.pipelineVersion;
    }

    public boolean hasStageStates() {
        return this.stageStates != null && !(this.stageStates instanceof SdkAutoConstructList);
    }

    public List<StageState> stageStates() {
        return this.stageStates;
    }

    public Instant created() {
        return this.created;
    }

    public Instant updated() {
        return this.updated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageStates());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.updated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineStateResponse)) {
            return false;
        }
        GetPipelineStateResponse other = (GetPipelineStateResponse)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineVersion(), other.pipelineVersion()) && Objects.equals(this.stageStates(), other.stageStates()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.updated(), other.updated());
    }

    public String toString() {
        return ToString.builder((String)"GetPipelineStateResponse").add("PipelineName", (Object)this.pipelineName()).add("PipelineVersion", (Object)this.pipelineVersion()).add("StageStates", this.stageStates()).add("Created", (Object)this.created()).add("Updated", (Object)this.updated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "pipelineVersion": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersion()));
            }
            case "stageStates": {
                return Optional.ofNullable(clazz.cast(this.stageStates()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "updated": {
                return Optional.ofNullable(clazz.cast(this.updated()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineStateResponse, T> g) {
        return obj -> g.apply((GetPipelineStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private String pipelineName;
        private Integer pipelineVersion;
        private List<StageState> stageStates = DefaultSdkAutoConstructList.getInstance();
        private Instant created;
        private Instant updated;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineStateResponse model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.pipelineVersion(model.pipelineVersion);
            this.stageStates(model.stageStates);
            this.created(model.created);
            this.updated(model.updated);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final Integer getPipelineVersion() {
            return this.pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        public final Collection<StageState.Builder> getStageStates() {
            return this.stageStates != null ? (Collection)this.stageStates.stream().map(StageState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stageStates(Collection<StageState> stageStates) {
            this.stageStates = StageStateListCopier.copy(stageStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageStates(StageState ... stageStates) {
            this.stageStates(Arrays.asList(stageStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageStates(Consumer<StageState.Builder> ... stageStates) {
            this.stageStates(Stream.of(stageStates).map(c -> (StageState)((StageState.Builder)StageState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStageStates(Collection<StageState.BuilderImpl> stageStates) {
            this.stageStates = StageStateListCopier.copyFromBuilder(stageStates);
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final Instant getUpdated() {
            return this.updated;
        }

        @Override
        public final Builder updated(Instant updated) {
            this.updated = updated;
            return this;
        }

        public final void setUpdated(Instant updated) {
            this.updated = updated;
        }

        @Override
        public GetPipelineStateResponse build() {
            return new GetPipelineStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPipelineStateResponse> {
        public Builder pipelineName(String var1);

        public Builder pipelineVersion(Integer var1);

        public Builder stageStates(Collection<StageState> var1);

        public Builder stageStates(StageState ... var1);

        public Builder stageStates(Consumer<StageState.Builder> ... var1);

        public Builder created(Instant var1);

        public Builder updated(Instant var1);
    }
}

