/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.StageExecution;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StageExecutionMarshaller {
    private static final MarshallingInfo<String> PIPELINEEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final StageExecutionMarshaller INSTANCE = new StageExecutionMarshaller();

    private StageExecutionMarshaller() {
    }

    public static StageExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StageExecution stageExecution, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stageExecution, (String)"stageExecution");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stageExecution.pipelineExecutionId(), PIPELINEEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)stageExecution.statusString(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

