/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActionTypeIdMarshaller {
    private static final MarshallingInfo<String> CATEGORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("category").isBinary(false).build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("owner").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("provider").isBinary(false).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();
    private static final ActionTypeIdMarshaller INSTANCE = new ActionTypeIdMarshaller();

    private ActionTypeIdMarshaller() {
    }

    public static ActionTypeIdMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActionTypeId actionTypeId, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)actionTypeId, (String)"actionTypeId");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)actionTypeId.categoryString(), CATEGORY_BINDING);
            protocolMarshaller.marshall((Object)actionTypeId.ownerString(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)actionTypeId.provider(), PROVIDER_BINDING);
            protocolMarshaller.marshall((Object)actionTypeId.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

