/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.TransitionStateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TransitionState
implements StructuredPojo,
ToCopyableBuilder<Builder, TransitionState> {
    private final Boolean enabled;
    private final String lastChangedBy;
    private final Instant lastChangedAt;
    private final String disabledReason;

    private TransitionState(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.lastChangedBy = builder.lastChangedBy;
        this.lastChangedAt = builder.lastChangedAt;
        this.disabledReason = builder.disabledReason;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String lastChangedBy() {
        return this.lastChangedBy;
    }

    public Instant lastChangedAt() {
        return this.lastChangedAt;
    }

    public String disabledReason() {
        return this.disabledReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastChangedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastChangedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitionState)) {
            return false;
        }
        TransitionState other = (TransitionState)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.lastChangedBy(), other.lastChangedBy()) && Objects.equals(this.lastChangedAt(), other.lastChangedAt()) && Objects.equals(this.disabledReason(), other.disabledReason());
    }

    public String toString() {
        return ToString.builder((String)"TransitionState").add("Enabled", (Object)this.enabled()).add("LastChangedBy", (Object)this.lastChangedBy()).add("LastChangedAt", (Object)this.lastChangedAt()).add("DisabledReason", (Object)this.disabledReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "lastChangedBy": {
                return Optional.of(clazz.cast(this.lastChangedBy()));
            }
            case "lastChangedAt": {
                return Optional.of(clazz.cast(this.lastChangedAt()));
            }
            case "disabledReason": {
                return Optional.of(clazz.cast(this.disabledReason()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransitionStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String lastChangedBy;
        private Instant lastChangedAt;
        private String disabledReason;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitionState model) {
            this.enabled(model.enabled);
            this.lastChangedBy(model.lastChangedBy);
            this.lastChangedAt(model.lastChangedAt);
            this.disabledReason(model.disabledReason);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getLastChangedBy() {
            return this.lastChangedBy;
        }

        @Override
        public final Builder lastChangedBy(String lastChangedBy) {
            this.lastChangedBy = lastChangedBy;
            return this;
        }

        public final void setLastChangedBy(String lastChangedBy) {
            this.lastChangedBy = lastChangedBy;
        }

        public final Instant getLastChangedAt() {
            return this.lastChangedAt;
        }

        @Override
        public final Builder lastChangedAt(Instant lastChangedAt) {
            this.lastChangedAt = lastChangedAt;
            return this;
        }

        public final void setLastChangedAt(Instant lastChangedAt) {
            this.lastChangedAt = lastChangedAt;
        }

        public final String getDisabledReason() {
            return this.disabledReason;
        }

        @Override
        public final Builder disabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
            return this;
        }

        public final void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        public TransitionState build() {
            return new TransitionState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TransitionState> {
        public Builder enabled(Boolean var1);

        public Builder lastChangedBy(String var1);

        public Builder lastChangedAt(Instant var1);

        public Builder disabledReason(String var1);
    }
}

