/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codepipeline.model.ApprovalResult;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutApprovalResultRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, PutApprovalResultRequest> {
    private final String pipelineName;
    private final String stageName;
    private final String actionName;
    private final ApprovalResult result;
    private final String token;

    private PutApprovalResultRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.actionName = builder.actionName;
        this.result = builder.result;
        this.token = builder.token;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String stageName() {
        return this.stageName;
    }

    public String actionName() {
        return this.actionName;
    }

    public ApprovalResult result() {
        return this.result;
    }

    public String token() {
        return this.token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApprovalResultRequest)) {
            return false;
        }
        PutApprovalResultRequest other = (PutApprovalResultRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.result(), other.result()) && Objects.equals(this.token(), other.token());
    }

    public String toString() {
        return ToString.builder((String)"PutApprovalResultRequest").add("PipelineName", (Object)this.pipelineName()).add("StageName", (Object)this.stageName()).add("ActionName", (Object)this.actionName()).add("Result", (Object)this.result()).add("Token", (Object)this.token()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "stageName": {
                return Optional.of(clazz.cast(this.stageName()));
            }
            case "actionName": {
                return Optional.of(clazz.cast(this.actionName()));
            }
            case "result": {
                return Optional.of(clazz.cast(this.result()));
            }
            case "token": {
                return Optional.of(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String actionName;
        private ApprovalResult result;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApprovalResultRequest model) {
            this.pipelineName(model.pipelineName);
            this.stageName(model.stageName);
            this.actionName(model.actionName);
            this.result(model.result);
            this.token(model.token);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final ApprovalResult.Builder getResult() {
            return this.result != null ? this.result.toBuilder() : null;
        }

        @Override
        public final Builder result(ApprovalResult result) {
            this.result = result;
            return this;
        }

        public final void setResult(ApprovalResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutApprovalResultRequest build() {
            return new PutApprovalResultRequest(this);
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    CopyableBuilder<Builder, PutApprovalResultRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder actionName(String var1);

        public Builder result(ApprovalResult var1);

        default public Builder result(Consumer<ApprovalResult.Builder> result) {
            return this.result((ApprovalResult)((ApprovalResult.Builder)ApprovalResult.builder().apply(result)).build());
        }

        public Builder token(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

