/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.StageTransitionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableStageTransitionRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, EnableStageTransitionRequest> {
    private final String pipelineName;
    private final String stageName;
    private final String transitionType;

    private EnableStageTransitionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.transitionType = builder.transitionType;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String stageName() {
        return this.stageName;
    }

    public StageTransitionType transitionType() {
        return StageTransitionType.fromValue(this.transitionType);
    }

    public String transitionTypeString() {
        return this.transitionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitionTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableStageTransitionRequest)) {
            return false;
        }
        EnableStageTransitionRequest other = (EnableStageTransitionRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.transitionTypeString(), other.transitionTypeString());
    }

    public String toString() {
        return ToString.builder((String)"EnableStageTransitionRequest").add("PipelineName", (Object)this.pipelineName()).add("StageName", (Object)this.stageName()).add("TransitionType", (Object)this.transitionTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "stageName": {
                return Optional.of(clazz.cast(this.stageName()));
            }
            case "transitionType": {
                return Optional.of(clazz.cast(this.transitionTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String transitionType;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableStageTransitionRequest model) {
            this.pipelineName(model.pipelineName);
            this.stageName(model.stageName);
            this.transitionType(model.transitionType);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getTransitionType() {
            return this.transitionType;
        }

        @Override
        public final Builder transitionType(String transitionType) {
            this.transitionType = transitionType;
            return this;
        }

        @Override
        public final Builder transitionType(StageTransitionType transitionType) {
            this.transitionType(transitionType.toString());
            return this;
        }

        public final void setTransitionType(String transitionType) {
            this.transitionType = transitionType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public EnableStageTransitionRequest build() {
            return new EnableStageTransitionRequest(this);
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    CopyableBuilder<Builder, EnableStageTransitionRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder transitionType(String var1);

        public Builder transitionType(StageTransitionType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

