/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.StageState;

@SdkInternalApi
public class StageStateMarshaller {
    private static final MarshallingInfo<String> STAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageName").build();
    private static final MarshallingInfo<StructuredPojo> INBOUNDTRANSITIONSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inboundTransitionState").build();
    private static final MarshallingInfo<List> ACTIONSTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionStates").build();
    private static final MarshallingInfo<StructuredPojo> LATESTEXECUTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestExecution").build();
    private static final StageStateMarshaller INSTANCE = new StageStateMarshaller();

    public static StageStateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StageState stageState, ProtocolMarshaller protocolMarshaller) {
        if (stageState == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)stageState.stageName(), STAGENAME_BINDING);
            protocolMarshaller.marshall((Object)stageState.inboundTransitionState(), INBOUNDTRANSITIONSTATE_BINDING);
            protocolMarshaller.marshall(stageState.actionStates(), ACTIONSTATES_BINDING);
            protocolMarshaller.marshall((Object)stageState.latestExecution(), LATESTEXECUTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

