/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration;

@SdkInternalApi
public class PipelineDeclarationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTSTORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactStore").build();
    private static final MarshallingInfo<List> STAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stages").build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final PipelineDeclarationMarshaller INSTANCE = new PipelineDeclarationMarshaller();

    public static PipelineDeclarationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PipelineDeclaration pipelineDeclaration, ProtocolMarshaller protocolMarshaller) {
        if (pipelineDeclaration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)pipelineDeclaration.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)pipelineDeclaration.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)pipelineDeclaration.artifactStore(), ARTIFACTSTORE_BINDING);
            protocolMarshaller.marshall(pipelineDeclaration.stages(), STAGES_BINDING);
            protocolMarshaller.marshall((Object)pipelineDeclaration.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

