/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.ExecutionDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExecutionDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, ExecutionDetails> {
    private final String summary;
    private final String externalExecutionId;
    private final Integer percentComplete;

    private ExecutionDetails(BuilderImpl builder) {
        this.summary = builder.summary;
        this.externalExecutionId = builder.externalExecutionId;
        this.percentComplete = builder.percentComplete;
    }

    public String summary() {
        return this.summary;
    }

    public String externalExecutionId() {
        return this.externalExecutionId;
    }

    public Integer percentComplete() {
        return this.percentComplete;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentComplete());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionDetails)) {
            return false;
        }
        ExecutionDetails other = (ExecutionDetails)obj;
        return Objects.equals(this.summary(), other.summary()) && Objects.equals(this.externalExecutionId(), other.externalExecutionId()) && Objects.equals(this.percentComplete(), other.percentComplete());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.summary() != null) {
            sb.append("Summary: ").append(this.summary()).append(",");
        }
        if (this.externalExecutionId() != null) {
            sb.append("ExternalExecutionId: ").append(this.externalExecutionId()).append(",");
        }
        if (this.percentComplete() != null) {
            sb.append("PercentComplete: ").append(this.percentComplete()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summary": {
                return Optional.of(clazz.cast(this.summary()));
            }
            case "externalExecutionId": {
                return Optional.of(clazz.cast(this.externalExecutionId()));
            }
            case "percentComplete": {
                return Optional.of(clazz.cast(this.percentComplete()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecutionDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String summary;
        private String externalExecutionId;
        private Integer percentComplete;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionDetails model) {
            this.summary(model.summary);
            this.externalExecutionId(model.externalExecutionId);
            this.percentComplete(model.percentComplete);
        }

        public final String getSummary() {
            return this.summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        public final String getExternalExecutionId() {
            return this.externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        public final Integer getPercentComplete() {
            return this.percentComplete;
        }

        @Override
        public final Builder percentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
            return this;
        }

        public final void setPercentComplete(Integer percentComplete) {
            this.percentComplete = percentComplete;
        }

        public ExecutionDetails build() {
            return new ExecutionDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExecutionDetails> {
        public Builder summary(String var1);

        public Builder externalExecutionId(String var1);

        public Builder percentComplete(Integer var1);
    }
}

