/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ArtifactDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, ArtifactDetails> {
    private final Integer minimumCount;
    private final Integer maximumCount;

    private ArtifactDetails(BuilderImpl builder) {
        this.minimumCount = builder.minimumCount;
        this.maximumCount = builder.maximumCount;
    }

    public Integer minimumCount() {
        return this.minimumCount;
    }

    public Integer maximumCount() {
        return this.maximumCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactDetails)) {
            return false;
        }
        ArtifactDetails other = (ArtifactDetails)obj;
        return Objects.equals(this.minimumCount(), other.minimumCount()) && Objects.equals(this.maximumCount(), other.maximumCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.minimumCount() != null) {
            sb.append("MinimumCount: ").append(this.minimumCount()).append(",");
        }
        if (this.maximumCount() != null) {
            sb.append("MaximumCount: ").append(this.maximumCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "minimumCount": {
                return Optional.of(clazz.cast(this.minimumCount()));
            }
            case "maximumCount": {
                return Optional.of(clazz.cast(this.maximumCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minimumCount;
        private Integer maximumCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactDetails model) {
            this.minimumCount(model.minimumCount);
            this.maximumCount(model.maximumCount);
        }

        public final Integer getMinimumCount() {
            return this.minimumCount;
        }

        @Override
        public final Builder minimumCount(Integer minimumCount) {
            this.minimumCount = minimumCount;
            return this;
        }

        public final void setMinimumCount(Integer minimumCount) {
            this.minimumCount = minimumCount;
        }

        public final Integer getMaximumCount() {
            return this.maximumCount;
        }

        @Override
        public final Builder maximumCount(Integer maximumCount) {
            this.maximumCount = maximumCount;
            return this;
        }

        public final void setMaximumCount(Integer maximumCount) {
            this.maximumCount = maximumCount;
        }

        public ArtifactDetails build() {
            return new ArtifactDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ArtifactDetails> {
        public Builder minimumCount(Integer var1);

        public Builder maximumCount(Integer var1);
    }
}

