/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionCategory;
import software.amazon.awssdk.services.codepipeline.model.ActionOwner;
import software.amazon.awssdk.services.codepipeline.transform.ActionTypeIdMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionTypeId
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionTypeId> {
    private final String category;
    private final String owner;
    private final String provider;
    private final String version;

    private ActionTypeId(BuilderImpl builder) {
        this.category = builder.category;
        this.owner = builder.owner;
        this.provider = builder.provider;
        this.version = builder.version;
    }

    public ActionCategory category() {
        return ActionCategory.fromValue(this.category);
    }

    public String categoryString() {
        return this.category;
    }

    public ActionOwner owner() {
        return ActionOwner.fromValue(this.owner);
    }

    public String ownerString() {
        return this.owner;
    }

    public String provider() {
        return this.provider;
    }

    public String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeId)) {
            return false;
        }
        ActionTypeId other = (ActionTypeId)obj;
        return Objects.equals(this.categoryString(), other.categoryString()) && Objects.equals(this.ownerString(), other.ownerString()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.categoryString() != null) {
            sb.append("Category: ").append(this.categoryString()).append(",");
        }
        if (this.ownerString() != null) {
            sb.append("Owner: ").append(this.ownerString()).append(",");
        }
        if (this.provider() != null) {
            sb.append("Provider: ").append(this.provider()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "category": {
                return Optional.of(clazz.cast(this.categoryString()));
            }
            case "owner": {
                return Optional.of(clazz.cast(this.ownerString()));
            }
            case "provider": {
                return Optional.of(clazz.cast(this.provider()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionTypeIdMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private String owner;
        private String provider;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeId model) {
            this.category(model.category);
            this.owner(model.owner);
            this.provider(model.provider);
            this.version(model.version);
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(ActionOwner owner) {
            this.owner(owner.toString());
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getProvider() {
            return this.provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public ActionTypeId build() {
            return new ActionTypeId(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionTypeId> {
        public Builder category(String var1);

        public Builder category(ActionCategory var1);

        public Builder owner(String var1);

        public Builder owner(ActionOwner var1);

        public Builder provider(String var1);

        public Builder version(String var1);
    }
}

