/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.QueryParamMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PollForJobsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PollForJobsRequest> {
    private final ActionTypeId actionTypeId;
    private final Integer maxBatchSize;
    private final Map<String, String> queryParam;

    private PollForJobsRequest(BuilderImpl builder) {
        this.actionTypeId = builder.actionTypeId;
        this.maxBatchSize = builder.maxBatchSize;
        this.queryParam = builder.queryParam;
    }

    public ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public Integer maxBatchSize() {
        return this.maxBatchSize;
    }

    public Map<String, String> queryParam() {
        return this.queryParam;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryParam());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForJobsRequest)) {
            return false;
        }
        PollForJobsRequest other = (PollForJobsRequest)((Object)obj);
        return Objects.equals(this.actionTypeId(), other.actionTypeId()) && Objects.equals(this.maxBatchSize(), other.maxBatchSize()) && Objects.equals(this.queryParam(), other.queryParam());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionTypeId() != null) {
            sb.append("ActionTypeId: ").append(this.actionTypeId()).append(",");
        }
        if (this.maxBatchSize() != null) {
            sb.append("MaxBatchSize: ").append(this.maxBatchSize()).append(",");
        }
        if (this.queryParam() != null) {
            sb.append("QueryParam: ").append(this.queryParam()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionTypeId": {
                return Optional.of(clazz.cast(this.actionTypeId()));
            }
            case "maxBatchSize": {
                return Optional.of(clazz.cast(this.maxBatchSize()));
            }
            case "queryParam": {
                return Optional.of(clazz.cast(this.queryParam()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ActionTypeId actionTypeId;
        private Integer maxBatchSize;
        private Map<String, String> queryParam;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForJobsRequest model) {
            this.actionTypeId(model.actionTypeId);
            this.maxBatchSize(model.maxBatchSize);
            this.queryParam(model.queryParam);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return this.actionTypeId != null ? this.actionTypeId.toBuilder() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        public final Integer getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public final Map<String, String> getQueryParam() {
            return this.queryParam;
        }

        @Override
        public final Builder queryParam(Map<String, String> queryParam) {
            this.queryParam = QueryParamMapCopier.copy(queryParam);
            return this;
        }

        public final void setQueryParam(Map<String, String> queryParam) {
            this.queryParam = QueryParamMapCopier.copy(queryParam);
        }

        public PollForJobsRequest build() {
            return new PollForJobsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PollForJobsRequest> {
        public Builder actionTypeId(ActionTypeId var1);

        default public Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return this.actionTypeId((ActionTypeId)((ActionTypeId.Builder)ActionTypeId.builder().apply(actionTypeId)).build());
        }

        public Builder maxBatchSize(Integer var1);

        public Builder queryParam(Map<String, String> var1);
    }
}

