/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;

public class ActionTypeIdUnmarshaller
implements Unmarshaller<ActionTypeId, JsonUnmarshallerContext> {
    private static final ActionTypeIdUnmarshaller INSTANCE = new ActionTypeIdUnmarshaller();

    public ActionTypeId unmarshall(JsonUnmarshallerContext context) throws Exception {
        ActionTypeId.Builder actionTypeIdBuilder = ActionTypeId.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("category", targetDepth)) {
                    context.nextToken();
                    actionTypeIdBuilder.category((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("owner", targetDepth)) {
                    context.nextToken();
                    actionTypeIdBuilder.owner((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("provider", targetDepth)) {
                    context.nextToken();
                    actionTypeIdBuilder.provider((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    actionTypeIdBuilder.version((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ActionTypeId)actionTypeIdBuilder.build();
    }

    public static ActionTypeIdUnmarshaller getInstance() {
        return INSTANCE;
    }
}

