/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.AWSSessionCredentials;

@SdkInternalApi
public class AWSSessionCredentialsMarshaller {
    private static final MarshallingInfo<String> ACCESSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessKeyId").build();
    private static final MarshallingInfo<String> SECRETACCESSKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secretAccessKey").build();
    private static final MarshallingInfo<String> SESSIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sessionToken").build();
    private static final AWSSessionCredentialsMarshaller INSTANCE = new AWSSessionCredentialsMarshaller();

    public static AWSSessionCredentialsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AWSSessionCredentials awsSessionCredentials, ProtocolMarshaller protocolMarshaller) {
        if (awsSessionCredentials == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)awsSessionCredentials.accessKeyId(), ACCESSKEYID_BINDING);
            protocolMarshaller.marshall((Object)awsSessionCredentials.secretAccessKey(), SECRETACCESSKEY_BINDING);
            protocolMarshaller.marshall((Object)awsSessionCredentials.sessionToken(), SESSIONTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

