/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codepipeline.model.Job;
import software.amazon.awssdk.services.codepipeline.model.JobListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PollForJobsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PollForJobsResponse> {
    private final List<Job> jobs;

    private PollForJobsResponse(BuilderImpl builder) {
        this.jobs = builder.jobs;
    }

    public List<Job> jobs() {
        return this.jobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobs() == null ? 0 : this.jobs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForJobsResponse)) {
            return false;
        }
        PollForJobsResponse other = (PollForJobsResponse)((Object)obj);
        if (other.jobs() == null ^ this.jobs() == null) {
            return false;
        }
        return other.jobs() == null || other.jobs().equals(this.jobs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobs() != null) {
            sb.append("Jobs: ").append(this.jobs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobs": {
                return Optional.of(clazz.cast(this.jobs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Job> jobs;

        private BuilderImpl() {
        }

        private BuilderImpl(PollForJobsResponse model) {
            this.jobs(model.jobs);
        }

        public final Collection<Job.Builder> getJobs() {
            return this.jobs != null ? (Collection)this.jobs.stream().map(Job::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<Job> jobs) {
            this.jobs = JobListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Job ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        public final void setJobs(Collection<Job.BuilderImpl> jobs) {
            this.jobs = JobListCopier.copyFromBuilder(jobs);
        }

        public PollForJobsResponse build() {
            return new PollForJobsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PollForJobsResponse> {
        public Builder jobs(Collection<Job> var1);

        public Builder jobs(Job ... var1);
    }
}

