/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionState;
import software.amazon.awssdk.services.codepipeline.model.ActionStateListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageExecution;
import software.amazon.awssdk.services.codepipeline.model.TransitionState;
import software.amazon.awssdk.services.codepipeline.transform.StageStateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StageState
implements StructuredPojo,
ToCopyableBuilder<Builder, StageState> {
    private final String stageName;
    private final TransitionState inboundTransitionState;
    private final List<ActionState> actionStates;
    private final StageExecution latestExecution;

    private StageState(BuilderImpl builder) {
        this.stageName = builder.stageName;
        this.inboundTransitionState = builder.inboundTransitionState;
        this.actionStates = builder.actionStates;
        this.latestExecution = builder.latestExecution;
    }

    public String stageName() {
        return this.stageName;
    }

    public TransitionState inboundTransitionState() {
        return this.inboundTransitionState;
    }

    public List<ActionState> actionStates() {
        return this.actionStates;
    }

    public StageExecution latestExecution() {
        return this.latestExecution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stageName() == null ? 0 : this.stageName().hashCode());
        hashCode = 31 * hashCode + (this.inboundTransitionState() == null ? 0 : this.inboundTransitionState().hashCode());
        hashCode = 31 * hashCode + (this.actionStates() == null ? 0 : this.actionStates().hashCode());
        hashCode = 31 * hashCode + (this.latestExecution() == null ? 0 : this.latestExecution().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageState)) {
            return false;
        }
        StageState other = (StageState)obj;
        if (other.stageName() == null ^ this.stageName() == null) {
            return false;
        }
        if (other.stageName() != null && !other.stageName().equals(this.stageName())) {
            return false;
        }
        if (other.inboundTransitionState() == null ^ this.inboundTransitionState() == null) {
            return false;
        }
        if (other.inboundTransitionState() != null && !other.inboundTransitionState().equals(this.inboundTransitionState())) {
            return false;
        }
        if (other.actionStates() == null ^ this.actionStates() == null) {
            return false;
        }
        if (other.actionStates() != null && !other.actionStates().equals(this.actionStates())) {
            return false;
        }
        if (other.latestExecution() == null ^ this.latestExecution() == null) {
            return false;
        }
        return other.latestExecution() == null || other.latestExecution().equals(this.latestExecution());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stageName() != null) {
            sb.append("StageName: ").append(this.stageName()).append(",");
        }
        if (this.inboundTransitionState() != null) {
            sb.append("InboundTransitionState: ").append(this.inboundTransitionState()).append(",");
        }
        if (this.actionStates() != null) {
            sb.append("ActionStates: ").append(this.actionStates()).append(",");
        }
        if (this.latestExecution() != null) {
            sb.append("LatestExecution: ").append(this.latestExecution()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stageName": {
                return Optional.of(clazz.cast(this.stageName()));
            }
            case "inboundTransitionState": {
                return Optional.of(clazz.cast(this.inboundTransitionState()));
            }
            case "actionStates": {
                return Optional.of(clazz.cast(this.actionStates()));
            }
            case "latestExecution": {
                return Optional.of(clazz.cast(this.latestExecution()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StageStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String stageName;
        private TransitionState inboundTransitionState;
        private List<ActionState> actionStates;
        private StageExecution latestExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(StageState model) {
            this.stageName(model.stageName);
            this.inboundTransitionState(model.inboundTransitionState);
            this.actionStates(model.actionStates);
            this.latestExecution(model.latestExecution);
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final TransitionState.Builder getInboundTransitionState() {
            return this.inboundTransitionState != null ? this.inboundTransitionState.toBuilder() : null;
        }

        @Override
        public final Builder inboundTransitionState(TransitionState inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState;
            return this;
        }

        public final void setInboundTransitionState(TransitionState.BuilderImpl inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState != null ? inboundTransitionState.build() : null;
        }

        public final Collection<ActionState.Builder> getActionStates() {
            return this.actionStates != null ? (Collection)this.actionStates.stream().map(ActionState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionStates(Collection<ActionState> actionStates) {
            this.actionStates = ActionStateListCopier.copy(actionStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionStates(ActionState ... actionStates) {
            this.actionStates(Arrays.asList(actionStates));
            return this;
        }

        public final void setActionStates(Collection<ActionState.BuilderImpl> actionStates) {
            this.actionStates = ActionStateListCopier.copyFromBuilder(actionStates);
        }

        public final StageExecution.Builder getLatestExecution() {
            return this.latestExecution != null ? this.latestExecution.toBuilder() : null;
        }

        @Override
        public final Builder latestExecution(StageExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final void setLatestExecution(StageExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        public StageState build() {
            return new StageState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StageState> {
        public Builder stageName(String var1);

        public Builder inboundTransitionState(TransitionState var1);

        public Builder actionStates(Collection<ActionState> var1);

        public Builder actionStates(ActionState ... var1);

        public Builder latestExecution(StageExecution var1);
    }
}

