/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AcknowledgeThirdPartyJobRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AcknowledgeThirdPartyJobRequest> {
    private final String jobId;
    private final String nonce;
    private final String clientToken;

    private AcknowledgeThirdPartyJobRequest(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.nonce = builder.nonce;
        this.clientToken = builder.clientToken;
    }

    public String jobId() {
        return this.jobId;
    }

    public String nonce() {
        return this.nonce;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobId() == null ? 0 : this.jobId().hashCode());
        hashCode = 31 * hashCode + (this.nonce() == null ? 0 : this.nonce().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcknowledgeThirdPartyJobRequest)) {
            return false;
        }
        AcknowledgeThirdPartyJobRequest other = (AcknowledgeThirdPartyJobRequest)((Object)obj);
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.nonce() == null ^ this.nonce() == null) {
            return false;
        }
        if (other.nonce() != null && !other.nonce().equals(this.nonce())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        return other.clientToken() == null || other.clientToken().equals(this.clientToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (this.nonce() != null) {
            sb.append("Nonce: ").append(this.nonce()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.of(clazz.cast(this.jobId()));
            }
            case "nonce": {
                return Optional.of(clazz.cast(this.nonce()));
            }
            case "clientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String nonce;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AcknowledgeThirdPartyJobRequest model) {
            this.jobId(model.jobId);
            this.nonce(model.nonce);
            this.clientToken(model.clientToken);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getNonce() {
            return this.nonce;
        }

        @Override
        public final Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public final void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public AcknowledgeThirdPartyJobRequest build() {
            return new AcknowledgeThirdPartyJobRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AcknowledgeThirdPartyJobRequest> {
        public Builder jobId(String var1);

        public Builder nonce(String var1);

        public Builder clientToken(String var1);
    }
}

