/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionDeclaration;

@SdkInternalApi
public class ActionDeclarationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<StructuredPojo> ACTIONTYPEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionTypeId").build();
    private static final MarshallingInfo<Integer> RUNORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("runOrder").build();
    private static final MarshallingInfo<Map> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuration").build();
    private static final MarshallingInfo<List> OUTPUTARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputArtifacts").build();
    private static final MarshallingInfo<List> INPUTARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputArtifacts").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final ActionDeclarationMarshaller INSTANCE = new ActionDeclarationMarshaller();

    public static ActionDeclarationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActionDeclaration actionDeclaration, ProtocolMarshaller protocolMarshaller) {
        if (actionDeclaration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)actionDeclaration.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)actionDeclaration.actionTypeId(), ACTIONTYPEID_BINDING);
            protocolMarshaller.marshall((Object)actionDeclaration.runOrder(), RUNORDER_BINDING);
            protocolMarshaller.marshall(actionDeclaration.configuration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall(actionDeclaration.outputArtifacts(), OUTPUTARTIFACTS_BINDING);
            protocolMarshaller.marshall(actionDeclaration.inputArtifacts(), INPUTARTIFACTS_BINDING);
            protocolMarshaller.marshall((Object)actionDeclaration.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

