/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codepipeline.model.ActionContext;

public class ActionContextUnmarshaller
implements Unmarshaller<ActionContext, JsonUnmarshallerContext> {
    private static final ActionContextUnmarshaller INSTANCE = new ActionContextUnmarshaller();

    public ActionContext unmarshall(JsonUnmarshallerContext context) throws Exception {
        ActionContext.Builder actionContextBuilder = ActionContext.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    actionContextBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ActionContext)actionContextBuilder.build();
    }

    public static ActionContextUnmarshaller getInstance() {
        return INSTANCE;
    }
}

