/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionConfigurationMapCopier;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeId;
import software.amazon.awssdk.services.codepipeline.model.InputArtifact;
import software.amazon.awssdk.services.codepipeline.model.InputArtifactListCopier;
import software.amazon.awssdk.services.codepipeline.model.OutputArtifact;
import software.amazon.awssdk.services.codepipeline.model.OutputArtifactListCopier;
import software.amazon.awssdk.services.codepipeline.transform.ActionDeclarationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActionDeclaration
implements StructuredPojo,
ToCopyableBuilder<Builder, ActionDeclaration> {
    private final String name;
    private final ActionTypeId actionTypeId;
    private final Integer runOrder;
    private final Map<String, String> configuration;
    private final List<OutputArtifact> outputArtifacts;
    private final List<InputArtifact> inputArtifacts;
    private final String roleArn;

    private ActionDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.actionTypeId = builder.actionTypeId;
        this.runOrder = builder.runOrder;
        this.configuration = builder.configuration;
        this.outputArtifacts = builder.outputArtifacts;
        this.inputArtifacts = builder.inputArtifacts;
        this.roleArn = builder.roleArn;
    }

    public String name() {
        return this.name;
    }

    public ActionTypeId actionTypeId() {
        return this.actionTypeId;
    }

    public Integer runOrder() {
        return this.runOrder;
    }

    public Map<String, String> configuration() {
        return this.configuration;
    }

    public List<OutputArtifact> outputArtifacts() {
        return this.outputArtifacts;
    }

    public List<InputArtifact> inputArtifacts() {
        return this.inputArtifacts;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.actionTypeId() == null ? 0 : this.actionTypeId().hashCode());
        hashCode = 31 * hashCode + (this.runOrder() == null ? 0 : this.runOrder().hashCode());
        hashCode = 31 * hashCode + (this.configuration() == null ? 0 : this.configuration().hashCode());
        hashCode = 31 * hashCode + (this.outputArtifacts() == null ? 0 : this.outputArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.inputArtifacts() == null ? 0 : this.inputArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionDeclaration)) {
            return false;
        }
        ActionDeclaration other = (ActionDeclaration)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.actionTypeId() == null ^ this.actionTypeId() == null) {
            return false;
        }
        if (other.actionTypeId() != null && !other.actionTypeId().equals(this.actionTypeId())) {
            return false;
        }
        if (other.runOrder() == null ^ this.runOrder() == null) {
            return false;
        }
        if (other.runOrder() != null && !other.runOrder().equals(this.runOrder())) {
            return false;
        }
        if (other.configuration() == null ^ this.configuration() == null) {
            return false;
        }
        if (other.configuration() != null && !other.configuration().equals(this.configuration())) {
            return false;
        }
        if (other.outputArtifacts() == null ^ this.outputArtifacts() == null) {
            return false;
        }
        if (other.outputArtifacts() != null && !other.outputArtifacts().equals(this.outputArtifacts())) {
            return false;
        }
        if (other.inputArtifacts() == null ^ this.inputArtifacts() == null) {
            return false;
        }
        if (other.inputArtifacts() != null && !other.inputArtifacts().equals(this.inputArtifacts())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        return other.roleArn() == null || other.roleArn().equals(this.roleArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.actionTypeId() != null) {
            sb.append("ActionTypeId: ").append(this.actionTypeId()).append(",");
        }
        if (this.runOrder() != null) {
            sb.append("RunOrder: ").append(this.runOrder()).append(",");
        }
        if (this.configuration() != null) {
            sb.append("Configuration: ").append(this.configuration()).append(",");
        }
        if (this.outputArtifacts() != null) {
            sb.append("OutputArtifacts: ").append(this.outputArtifacts()).append(",");
        }
        if (this.inputArtifacts() != null) {
            sb.append("InputArtifacts: ").append(this.inputArtifacts()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionDeclarationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private ActionTypeId actionTypeId;
        private Integer runOrder;
        private Map<String, String> configuration;
        private List<OutputArtifact> outputArtifacts;
        private List<InputArtifact> inputArtifacts;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionDeclaration model) {
            this.setName(model.name);
            this.setActionTypeId(model.actionTypeId);
            this.setRunOrder(model.runOrder);
            this.setConfiguration(model.configuration);
            this.setOutputArtifacts(model.outputArtifacts);
            this.setInputArtifacts(model.inputArtifacts);
            this.setRoleArn(model.roleArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ActionTypeId getActionTypeId() {
            return this.actionTypeId;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final void setActionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
        }

        public final Integer getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final Builder runOrder(Integer runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public final void setRunOrder(Integer runOrder) {
            this.runOrder = runOrder;
        }

        public final Map<String, String> getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
            return this;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
        }

        public final Collection<OutputArtifact> getOutputArtifacts() {
            return this.outputArtifacts;
        }

        @Override
        public final Builder outputArtifacts(Collection<OutputArtifact> outputArtifacts) {
            this.outputArtifacts = OutputArtifactListCopier.copy(outputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(OutputArtifact ... outputArtifacts) {
            this.outputArtifacts(Arrays.asList(outputArtifacts));
            return this;
        }

        public final void setOutputArtifacts(Collection<OutputArtifact> outputArtifacts) {
            this.outputArtifacts = OutputArtifactListCopier.copy(outputArtifacts);
        }

        public final Collection<InputArtifact> getInputArtifacts() {
            return this.inputArtifacts;
        }

        @Override
        public final Builder inputArtifacts(Collection<InputArtifact> inputArtifacts) {
            this.inputArtifacts = InputArtifactListCopier.copy(inputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(InputArtifact ... inputArtifacts) {
            this.inputArtifacts(Arrays.asList(inputArtifacts));
            return this;
        }

        public final void setInputArtifacts(Collection<InputArtifact> inputArtifacts) {
            this.inputArtifacts = InputArtifactListCopier.copy(inputArtifacts);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public ActionDeclaration build() {
            return new ActionDeclaration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActionDeclaration> {
        public Builder name(String var1);

        public Builder actionTypeId(ActionTypeId var1);

        public Builder runOrder(Integer var1);

        public Builder configuration(Map<String, String> var1);

        public Builder outputArtifacts(Collection<OutputArtifact> var1);

        public Builder outputArtifacts(OutputArtifact ... var1);

        public Builder inputArtifacts(Collection<InputArtifact> var1);

        public Builder inputArtifacts(InputArtifact ... var1);

        public Builder roleArn(String var1);
    }
}

