/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeSettings;

public class ActionTypeSettingsUnmarshaller
implements Unmarshaller<ActionTypeSettings, JsonUnmarshallerContext> {
    private static final ActionTypeSettingsUnmarshaller INSTANCE = new ActionTypeSettingsUnmarshaller();

    public ActionTypeSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        ActionTypeSettings.Builder actionTypeSettingsBuilder = ActionTypeSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("thirdPartyConfigurationUrl", targetDepth)) {
                    context.nextToken();
                    actionTypeSettingsBuilder.thirdPartyConfigurationUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("entityUrlTemplate", targetDepth)) {
                    context.nextToken();
                    actionTypeSettingsBuilder.entityUrlTemplate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("executionUrlTemplate", targetDepth)) {
                    context.nextToken();
                    actionTypeSettingsBuilder.executionUrlTemplate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("revisionUrlTemplate", targetDepth)) {
                    context.nextToken();
                    actionTypeSettingsBuilder.revisionUrlTemplate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ActionTypeSettings)actionTypeSettingsBuilder.build();
    }

    public static ActionTypeSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

