/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus;
import software.amazon.awssdk.services.codepipeline.transform.StageExecutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StageExecution
implements StructuredPojo,
ToCopyableBuilder<Builder, StageExecution> {
    private final String pipelineExecutionId;
    private final String status;

    private StageExecution(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.status = builder.status;
    }

    public String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineExecutionId() == null ? 0 : this.pipelineExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageExecution)) {
            return false;
        }
        StageExecution other = (StageExecution)obj;
        if (other.pipelineExecutionId() == null ^ this.pipelineExecutionId() == null) {
            return false;
        }
        if (other.pipelineExecutionId() != null && !other.pipelineExecutionId().equals(this.pipelineExecutionId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineExecutionId() != null) {
            sb.append("PipelineExecutionId: ").append(this.pipelineExecutionId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StageExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String pipelineExecutionId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StageExecution model) {
            this.setPipelineExecutionId(model.pipelineExecutionId);
            this.setStatus(model.status);
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StageExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public StageExecution build() {
            return new StageExecution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StageExecution> {
        public Builder pipelineExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(StageExecutionStatus var1);
    }
}

