/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionDeclaration;
import software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration;
import software.amazon.awssdk.services.codepipeline.model.StageActionDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageBlockerDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.transform.StageDeclarationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StageDeclaration
implements StructuredPojo,
ToCopyableBuilder<Builder, StageDeclaration> {
    private final String name;
    private final List<BlockerDeclaration> blockers;
    private final List<ActionDeclaration> actions;

    private StageDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.blockers = builder.blockers;
        this.actions = builder.actions;
    }

    public String name() {
        return this.name;
    }

    public List<BlockerDeclaration> blockers() {
        return this.blockers;
    }

    public List<ActionDeclaration> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.blockers() == null ? 0 : this.blockers().hashCode());
        hashCode = 31 * hashCode + (this.actions() == null ? 0 : this.actions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageDeclaration)) {
            return false;
        }
        StageDeclaration other = (StageDeclaration)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.blockers() == null ^ this.blockers() == null) {
            return false;
        }
        if (other.blockers() != null && !other.blockers().equals(this.blockers())) {
            return false;
        }
        if (other.actions() == null ^ this.actions() == null) {
            return false;
        }
        return other.actions() == null || other.actions().equals(this.actions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.blockers() != null) {
            sb.append("Blockers: ").append(this.blockers()).append(",");
        }
        if (this.actions() != null) {
            sb.append("Actions: ").append(this.actions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StageDeclarationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private List<BlockerDeclaration> blockers;
        private List<ActionDeclaration> actions;

        private BuilderImpl() {
        }

        private BuilderImpl(StageDeclaration model) {
            this.setName(model.name);
            this.setBlockers(model.blockers);
            this.setActions(model.actions);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<BlockerDeclaration> getBlockers() {
            return this.blockers;
        }

        @Override
        public final Builder blockers(Collection<BlockerDeclaration> blockers) {
            this.blockers = StageBlockerDeclarationListCopier.copy(blockers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockers(BlockerDeclaration ... blockers) {
            this.blockers(Arrays.asList(blockers));
            return this;
        }

        public final void setBlockers(Collection<BlockerDeclaration> blockers) {
            this.blockers = StageBlockerDeclarationListCopier.copy(blockers);
        }

        @SafeVarargs
        public final void setBlockers(BlockerDeclaration ... blockers) {
            this.blockers(Arrays.asList(blockers));
        }

        public final Collection<ActionDeclaration> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<ActionDeclaration> actions) {
            this.actions = StageActionDeclarationListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ActionDeclaration ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<ActionDeclaration> actions) {
            this.actions = StageActionDeclarationListCopier.copy(actions);
        }

        @SafeVarargs
        public final void setActions(ActionDeclaration ... actions) {
            this.actions(Arrays.asList(actions));
        }

        public StageDeclaration build() {
            return new StageDeclaration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StageDeclaration> {
        public Builder name(String var1);

        public Builder blockers(Collection<BlockerDeclaration> var1);

        public Builder blockers(BlockerDeclaration ... var1);

        public Builder actions(Collection<ActionDeclaration> var1);

        public Builder actions(ActionDeclaration ... var1);
    }
}

