/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ArtifactStore;
import software.amazon.awssdk.services.codepipeline.model.PipelineStageDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageDeclaration;
import software.amazon.awssdk.services.codepipeline.transform.PipelineDeclarationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineDeclaration
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineDeclaration> {
    private final String name;
    private final String roleArn;
    private final ArtifactStore artifactStore;
    private final List<StageDeclaration> stages;
    private final Integer version;

    private PipelineDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.artifactStore = builder.artifactStore;
        this.stages = builder.stages;
        this.version = builder.version;
    }

    public String name() {
        return this.name;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public ArtifactStore artifactStore() {
        return this.artifactStore;
    }

    public List<StageDeclaration> stages() {
        return this.stages;
    }

    public Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.artifactStore() == null ? 0 : this.artifactStore().hashCode());
        hashCode = 31 * hashCode + (this.stages() == null ? 0 : this.stages().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDeclaration)) {
            return false;
        }
        PipelineDeclaration other = (PipelineDeclaration)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.artifactStore() == null ^ this.artifactStore() == null) {
            return false;
        }
        if (other.artifactStore() != null && !other.artifactStore().equals(this.artifactStore())) {
            return false;
        }
        if (other.stages() == null ^ this.stages() == null) {
            return false;
        }
        if (other.stages() != null && !other.stages().equals(this.stages())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        return other.version() == null || other.version().equals(this.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.artifactStore() != null) {
            sb.append("ArtifactStore: ").append(this.artifactStore()).append(",");
        }
        if (this.stages() != null) {
            sb.append("Stages: ").append(this.stages()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineDeclarationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String roleArn;
        private ArtifactStore artifactStore;
        private List<StageDeclaration> stages;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDeclaration model) {
            this.setName(model.name);
            this.setRoleArn(model.roleArn);
            this.setArtifactStore(model.artifactStore);
            this.setStages(model.stages);
            this.setVersion(model.version);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final ArtifactStore getArtifactStore() {
            return this.artifactStore;
        }

        @Override
        public final Builder artifactStore(ArtifactStore artifactStore) {
            this.artifactStore = artifactStore;
            return this;
        }

        public final void setArtifactStore(ArtifactStore artifactStore) {
            this.artifactStore = artifactStore;
        }

        public final Collection<StageDeclaration> getStages() {
            return this.stages;
        }

        @Override
        public final Builder stages(Collection<StageDeclaration> stages) {
            this.stages = PipelineStageDeclarationListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(StageDeclaration ... stages) {
            this.stages(Arrays.asList(stages));
            return this;
        }

        public final void setStages(Collection<StageDeclaration> stages) {
            this.stages = PipelineStageDeclarationListCopier.copy(stages);
        }

        @SafeVarargs
        public final void setStages(StageDeclaration ... stages) {
            this.stages(Arrays.asList(stages));
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public PipelineDeclaration build() {
            return new PipelineDeclaration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineDeclaration> {
        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder artifactStore(ArtifactStore var1);

        public Builder stages(Collection<StageDeclaration> var1);

        public Builder stages(StageDeclaration ... var1);

        public Builder version(Integer var1);
    }
}

