/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPipelineExecutionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPipelineExecutionsResponse> {
    private final List<PipelineExecutionSummary> pipelineExecutionSummaries;
    private final String nextToken;

    private ListPipelineExecutionsResponse(BuilderImpl builder) {
        this.pipelineExecutionSummaries = builder.pipelineExecutionSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<PipelineExecutionSummary> pipelineExecutionSummaries() {
        return this.pipelineExecutionSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineExecutionSummaries() == null ? 0 : this.pipelineExecutionSummaries().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineExecutionsResponse)) {
            return false;
        }
        ListPipelineExecutionsResponse other = (ListPipelineExecutionsResponse)((Object)obj);
        if (other.pipelineExecutionSummaries() == null ^ this.pipelineExecutionSummaries() == null) {
            return false;
        }
        if (other.pipelineExecutionSummaries() != null && !other.pipelineExecutionSummaries().equals(this.pipelineExecutionSummaries())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pipelineExecutionSummaries() != null) {
            sb.append("PipelineExecutionSummaries: ").append(this.pipelineExecutionSummaries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PipelineExecutionSummary> pipelineExecutionSummaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineExecutionsResponse model) {
            this.setPipelineExecutionSummaries(model.pipelineExecutionSummaries);
            this.setNextToken(model.nextToken);
        }

        public final Collection<PipelineExecutionSummary> getPipelineExecutionSummaries() {
            return this.pipelineExecutionSummaries;
        }

        @Override
        public final Builder pipelineExecutionSummaries(Collection<PipelineExecutionSummary> pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries = PipelineExecutionSummaryListCopier.copy(pipelineExecutionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineExecutionSummaries(PipelineExecutionSummary ... pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries(Arrays.asList(pipelineExecutionSummaries));
            return this;
        }

        public final void setPipelineExecutionSummaries(Collection<PipelineExecutionSummary> pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries = PipelineExecutionSummaryListCopier.copy(pipelineExecutionSummaries);
        }

        @SafeVarargs
        public final void setPipelineExecutionSummaries(PipelineExecutionSummary ... pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries(Arrays.asList(pipelineExecutionSummaries));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListPipelineExecutionsResponse build() {
            return new ListPipelineExecutionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPipelineExecutionsResponse> {
        public Builder pipelineExecutionSummaries(Collection<PipelineExecutionSummary> var1);

        public Builder pipelineExecutionSummaries(PipelineExecutionSummary ... var1);

        public Builder nextToken(String var1);
    }
}

