/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.FailureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailureDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailureDetails> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailureDetails.getter(FailureDetails::typeAsString)).setter(FailureDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailureDetails.getter(FailureDetails::message)).setter(FailureDetails.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> EXTERNAL_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FailureDetails.getter(FailureDetails::externalExecutionId)).setter(FailureDetails.setter(Builder::externalExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MESSAGE_FIELD, EXTERNAL_EXECUTION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String message;
    private final String externalExecutionId;

    private FailureDetails(BuilderImpl builder) {
        this.type = builder.type;
        this.message = builder.message;
        this.externalExecutionId = builder.externalExecutionId;
    }

    public FailureType type() {
        return FailureType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public String externalExecutionId() {
        return this.externalExecutionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalExecutionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureDetails)) {
            return false;
        }
        FailureDetails other = (FailureDetails)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.externalExecutionId(), other.externalExecutionId());
    }

    public String toString() {
        return ToString.builder((String)"FailureDetails").add("Type", (Object)this.typeAsString()).add("Message", (Object)this.message()).add("ExternalExecutionId", (Object)this.externalExecutionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "externalExecutionId": {
                return Optional.ofNullable(clazz.cast(this.externalExecutionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailureDetails, T> g) {
        return obj -> g.apply((FailureDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String message;
        private String externalExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureDetails model) {
            this.type(model.type);
            this.message(model.message);
            this.externalExecutionId(model.externalExecutionId);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FailureType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getExternalExecutionId() {
            return this.externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        public FailureDetails build() {
            return new FailureDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailureDetails> {
        public Builder type(String var1);

        public Builder type(FailureType var1);

        public Builder message(String var1);

        public Builder externalExecutionId(String var1);
    }
}

