/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.PipelineContext;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PipelineContextMarshaller {
    private static final MarshallingInfo<String> PIPELINENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stage").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("action").isBinary(false).build();
    private static final PipelineContextMarshaller INSTANCE = new PipelineContextMarshaller();

    private PipelineContextMarshaller() {
    }

    public static PipelineContextMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PipelineContext pipelineContext, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)pipelineContext, (String)"pipelineContext");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)pipelineContext.pipelineName(), PIPELINENAME_BINDING);
            protocolMarshaller.marshall((Object)pipelineContext.stage(), STAGE_BINDING);
            protocolMarshaller.marshall((Object)pipelineContext.action(), ACTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

