/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.WebhookAuthConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebhookAuthConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, WebhookAuthConfiguration> {
    private final String allowedIPRange;
    private final String secretToken;

    private WebhookAuthConfiguration(BuilderImpl builder) {
        this.allowedIPRange = builder.allowedIPRange;
        this.secretToken = builder.secretToken;
    }

    public String allowedIPRange() {
        return this.allowedIPRange;
    }

    public String secretToken() {
        return this.secretToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedIPRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebhookAuthConfiguration)) {
            return false;
        }
        WebhookAuthConfiguration other = (WebhookAuthConfiguration)obj;
        return Objects.equals(this.allowedIPRange(), other.allowedIPRange()) && Objects.equals(this.secretToken(), other.secretToken());
    }

    public String toString() {
        return ToString.builder((String)"WebhookAuthConfiguration").add("AllowedIPRange", (Object)this.allowedIPRange()).add("SecretToken", (Object)this.secretToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedIPRange": {
                return Optional.ofNullable(clazz.cast(this.allowedIPRange()));
            }
            case "SecretToken": {
                return Optional.ofNullable(clazz.cast(this.secretToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebhookAuthConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String allowedIPRange;
        private String secretToken;

        private BuilderImpl() {
        }

        private BuilderImpl(WebhookAuthConfiguration model) {
            this.allowedIPRange(model.allowedIPRange);
            this.secretToken(model.secretToken);
        }

        public final String getAllowedIPRange() {
            return this.allowedIPRange;
        }

        @Override
        public final Builder allowedIPRange(String allowedIPRange) {
            this.allowedIPRange = allowedIPRange;
            return this;
        }

        public final void setAllowedIPRange(String allowedIPRange) {
            this.allowedIPRange = allowedIPRange;
        }

        public final String getSecretToken() {
            return this.secretToken;
        }

        @Override
        public final Builder secretToken(String secretToken) {
            this.secretToken = secretToken;
            return this;
        }

        public final void setSecretToken(String secretToken) {
            this.secretToken = secretToken;
        }

        public WebhookAuthConfiguration build() {
            return new WebhookAuthConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebhookAuthConfiguration> {
        public Builder allowedIPRange(String var1);

        public Builder secretToken(String var1);
    }
}

