/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.EncryptionKey;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EncryptionKeyMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final EncryptionKeyMarshaller INSTANCE = new EncryptionKeyMarshaller();

    private EncryptionKeyMarshaller() {
    }

    public static EncryptionKeyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EncryptionKey encryptionKey, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)encryptionKey, (String)"encryptionKey");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)encryptionKey.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)encryptionKey.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

