/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BlockerDeclarationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final BlockerDeclarationMarshaller INSTANCE = new BlockerDeclarationMarshaller();

    private BlockerDeclarationMarshaller() {
    }

    public static BlockerDeclarationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BlockerDeclaration blockerDeclaration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)blockerDeclaration, (String)"blockerDeclaration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)blockerDeclaration.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)blockerDeclaration.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

