/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.AWSSessionCredentials;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AWSSessionCredentialsMarshaller {
    private static final MarshallingInfo<String> ACCESSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessKeyId").isBinary(false).build();
    private static final MarshallingInfo<String> SECRETACCESSKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secretAccessKey").isBinary(false).build();
    private static final MarshallingInfo<String> SESSIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sessionToken").isBinary(false).build();
    private static final AWSSessionCredentialsMarshaller INSTANCE = new AWSSessionCredentialsMarshaller();

    private AWSSessionCredentialsMarshaller() {
    }

    public static AWSSessionCredentialsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AWSSessionCredentials awsSessionCredentials, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)awsSessionCredentials, (String)"awsSessionCredentials");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)awsSessionCredentials.accessKeyId(), ACCESSKEYID_BINDING);
            protocolMarshaller.marshall((Object)awsSessionCredentials.secretAccessKey(), SECRETACCESSKEY_BINDING);
            protocolMarshaller.marshall((Object)awsSessionCredentials.sessionToken(), SESSIONTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

