/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus;
import software.amazon.awssdk.services.codepipeline.transform.PipelineExecutionSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineExecutionSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineExecutionSummary> {
    private final String pipelineExecutionId;
    private final String status;
    private final Instant startTime;
    private final Instant lastUpdateTime;

    private PipelineExecutionSummary(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public PipelineExecutionStatus status() {
        return PipelineExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionSummary)) {
            return false;
        }
        PipelineExecutionSummary other = (PipelineExecutionSummary)obj;
        return Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public String toString() {
        return ToString.builder((String)"PipelineExecutionSummary").add("PipelineExecutionId", (Object)this.pipelineExecutionId()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineExecutionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineExecutionId;
        private String status;
        private Instant startTime;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionSummary model) {
            this.pipelineExecutionId(model.pipelineExecutionId);
            this.status(model.status);
            this.startTime(model.startTime);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public PipelineExecutionSummary build() {
            return new PipelineExecutionSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineExecutionSummary> {
        public Builder pipelineExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(PipelineExecutionStatus var1);

        public Builder startTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

