/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.codepipeline.model.ActionCategory;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteCustomActionTypeRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, DeleteCustomActionTypeRequest> {
    private final String category;
    private final String provider;
    private final String version;

    private DeleteCustomActionTypeRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.provider = builder.provider;
        this.version = builder.version;
    }

    public ActionCategory category() {
        return ActionCategory.fromValue(this.category);
    }

    public String categoryAsString() {
        return this.category;
    }

    public String provider() {
        return this.provider;
    }

    public String version() {
        return this.version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCustomActionTypeRequest)) {
            return false;
        }
        DeleteCustomActionTypeRequest other = (DeleteCustomActionTypeRequest)((Object)obj);
        return Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"DeleteCustomActionTypeRequest").add("Category", (Object)this.categoryAsString()).add("Provider", (Object)this.provider()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String category;
        private String provider;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCustomActionTypeRequest model) {
            super(model);
            this.category(model.category);
            this.provider(model.provider);
            this.version(model.version);
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getProvider() {
            return this.provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCustomActionTypeRequest build() {
            return new DeleteCustomActionTypeRequest(this);
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    CopyableBuilder<Builder, DeleteCustomActionTypeRequest> {
        public Builder category(String var1);

        public Builder category(ActionCategory var1);

        public Builder provider(String var1);

        public Builder version(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

