/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ActionExecution;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActionExecutionMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("summary").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTSTATUSCHANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatusChange").isBinary(false).build();
    private static final MarshallingInfo<String> TOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("token").isBinary(false).build();
    private static final MarshallingInfo<String> LASTUPDATEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedBy").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALEXECUTIONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalExecutionUrl").isBinary(false).build();
    private static final MarshallingInfo<Integer> PERCENTCOMPLETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("percentComplete").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ERRORDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorDetails").isBinary(false).build();
    private static final ActionExecutionMarshaller INSTANCE = new ActionExecutionMarshaller();

    private ActionExecutionMarshaller() {
    }

    public static ActionExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActionExecution actionExecution, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)actionExecution, (String)"actionExecution");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)actionExecution.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.summary(), SUMMARY_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.lastStatusChange(), LASTSTATUSCHANGE_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.token(), TOKEN_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.lastUpdatedBy(), LASTUPDATEDBY_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.externalExecutionId(), EXTERNALEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.externalExecutionUrl(), EXTERNALEXECUTIONURL_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.percentComplete(), PERCENTCOMPLETE_BINDING);
            protocolMarshaller.marshall((Object)actionExecution.errorDetails(), ERRORDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

