/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ArtifactRevision;
import software.amazon.awssdk.services.codepipeline.model.ArtifactRevisionListCopier;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus;
import software.amazon.awssdk.services.codepipeline.transform.PipelineExecutionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineExecution
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineExecution> {
    private final String pipelineName;
    private final Integer pipelineVersion;
    private final String pipelineExecutionId;
    private final String status;
    private final List<ArtifactRevision> artifactRevisions;

    private PipelineExecution(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.pipelineVersion = builder.pipelineVersion;
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.status = builder.status;
        this.artifactRevisions = builder.artifactRevisions;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public Integer pipelineVersion() {
        return this.pipelineVersion;
    }

    public String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public PipelineExecutionStatus status() {
        return PipelineExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public List<ArtifactRevision> artifactRevisions() {
        return this.artifactRevisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactRevisions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecution)) {
            return false;
        }
        PipelineExecution other = (PipelineExecution)obj;
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineVersion(), other.pipelineVersion()) && Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.artifactRevisions(), other.artifactRevisions());
    }

    public String toString() {
        return ToString.builder((String)"PipelineExecution").add("PipelineName", (Object)this.pipelineName()).add("PipelineVersion", (Object)this.pipelineVersion()).add("PipelineExecutionId", (Object)this.pipelineExecutionId()).add("Status", (Object)this.statusAsString()).add("ArtifactRevisions", this.artifactRevisions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "pipelineVersion": {
                return Optional.of(clazz.cast(this.pipelineVersion()));
            }
            case "pipelineExecutionId": {
                return Optional.of(clazz.cast(this.pipelineExecutionId()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "artifactRevisions": {
                return Optional.of(clazz.cast(this.artifactRevisions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private Integer pipelineVersion;
        private String pipelineExecutionId;
        private String status;
        private List<ArtifactRevision> artifactRevisions;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecution model) {
            this.pipelineName(model.pipelineName);
            this.pipelineVersion(model.pipelineVersion);
            this.pipelineExecutionId(model.pipelineExecutionId);
            this.status(model.status);
            this.artifactRevisions(model.artifactRevisions);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final Integer getPipelineVersion() {
            return this.pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<ArtifactRevision.Builder> getArtifactRevisions() {
            return this.artifactRevisions != null ? (Collection)this.artifactRevisions.stream().map(ArtifactRevision::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder artifactRevisions(Collection<ArtifactRevision> artifactRevisions) {
            this.artifactRevisions = ArtifactRevisionListCopier.copy(artifactRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifactRevisions(ArtifactRevision ... artifactRevisions) {
            this.artifactRevisions(Arrays.asList(artifactRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifactRevisions(Consumer<ArtifactRevision.Builder> ... artifactRevisions) {
            this.artifactRevisions(Stream.of(artifactRevisions).map(c -> (ArtifactRevision)((ArtifactRevision.Builder)ArtifactRevision.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArtifactRevisions(Collection<ArtifactRevision.BuilderImpl> artifactRevisions) {
            this.artifactRevisions = ArtifactRevisionListCopier.copyFromBuilder(artifactRevisions);
        }

        public PipelineExecution build() {
            return new PipelineExecution(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineExecution> {
        public Builder pipelineName(String var1);

        public Builder pipelineVersion(Integer var1);

        public Builder pipelineExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(PipelineExecutionStatus var1);

        public Builder artifactRevisions(Collection<ArtifactRevision> var1);

        public Builder artifactRevisions(ArtifactRevision ... var1);

        public Builder artifactRevisions(Consumer<ArtifactRevision.Builder> ... var1);
    }
}

